/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.method;

import com.google.common.collect.ImmutableMap;
import eu.timepit.refined.api.RefType$;
import eu.timepit.refined.api.Refined;
import eu.timepit.refined.boolean;
import eu.timepit.refined.collection;
import eu.timepit.refined.string;
import jakarta.inject.Inject;
import java.io.Serializable;
import org.apache.james.core.Username;
import org.apache.james.jmap.core.CapabilityIdentifier$;
import org.apache.james.jmap.core.Properties;
import org.apache.james.jmap.core.Properties$;
import org.apache.james.jmap.core.SetError;
import org.apache.james.jmap.core.SetError$;
import org.apache.james.jmap.json.MailboxSerializer;
import org.apache.james.jmap.mail.InvalidPatchException;
import org.apache.james.jmap.mail.InvalidPropertyException;
import org.apache.james.jmap.mail.InvalidUpdateException;
import org.apache.james.jmap.mail.IsSubscribed;
import org.apache.james.jmap.mail.IsSubscribedUpdate;
import org.apache.james.jmap.mail.MailboxGet$;
import org.apache.james.jmap.mail.MailboxPatchObject;
import org.apache.james.jmap.mail.MailboxSetRequest;
import org.apache.james.jmap.mail.MailboxSetResponse$;
import org.apache.james.jmap.mail.MailboxUpdateResponse;
import org.apache.james.jmap.mail.NameUpdate;
import org.apache.james.jmap.mail.ParentIdUpdate;
import org.apache.james.jmap.mail.ServerSetPropertyException;
import org.apache.james.jmap.mail.UnparsedMailboxId;
import org.apache.james.jmap.mail.UnsupportedPropertyUpdatedException;
import org.apache.james.jmap.mail.ValidatedMailboxPatchObject;
import org.apache.james.jmap.method.LoopInMailboxGraphException;
import org.apache.james.jmap.method.MailboxSetMethod$;
import org.apache.james.jmap.method.MailboxSetUpdatePerformer$;
import org.apache.james.jmap.method.MailboxSetUpdatePerformer$MailboxUpdateResults$;
import org.apache.james.jmap.method.SystemMailboxChangeException;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.Role;
import org.apache.james.mailbox.SubscriptionManager;
import org.apache.james.mailbox.exception.DifferentDomainException;
import org.apache.james.mailbox.exception.InsufficientRightsException;
import org.apache.james.mailbox.exception.MailboxExistsException;
import org.apache.james.mailbox.exception.MailboxNameException;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxMetaData;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.search.MailboxNameExpression;
import org.apache.james.mailbox.model.search.MailboxQuery;
import org.apache.james.mailbox.model.search.PrefixedWildcard;
import org.apache.james.util.AuditTrail;
import org.apache.james.util.ReactorUtils;
import org.reactivestreams.Publisher;
import reactor.core.scala.publisher.SFlux;
import reactor.core.scala.publisher.SFlux$;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.duration.Duration;
import scala.jdk.CollectionConverters$;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0011et!\u00023f\u0011\u0003\u0001h!\u0002:f\u0011\u0003\u0019\b\"\u0002>\u0002\t\u0003Y\bb\u0002?\u0002\u0005\u0004%I! \u0005\b\u0003\u0013\t\u0001\u0015!\u0003\u007f\r%\tY!\u0001I\u0001$C\tiA\u0002\u0004\u0003\u001c\u0005\u0001%Q\u0004\u0005\u000b\u0003o1!Q3A\u0005\u0002\t}\u0001BCA$\r\tE\t\u0015!\u0003\u0003\"!1!P\u0002C\u0001\u0005cA\u0011\"!%\u0007\u0003\u0003%\tAa\u000e\t\u0013\u0005me!%A\u0005\u0002\tm\u0002\"CA`\r\u0005\u0005I\u0011IAa\u0011%\t\u0019NBA\u0001\n\u0003\t)\u000eC\u0005\u0002^\u001a\t\t\u0011\"\u0001\u0003@!I\u00111\u001e\u0004\u0002\u0002\u0013\u0005\u0013Q\u001e\u0005\n\u0003w4\u0011\u0011!C\u0001\u0005\u0007B\u0011Ba\u0002\u0007\u0003\u0003%\tEa\u0012\t\u0013\t5a!!A\u0005B\t=\u0001\"\u0003B\t\r\u0005\u0005I\u0011\tB\n\u0011%\u0011)BBA\u0001\n\u0003\u0012YeB\u0005\u0003P\u0005\t\t\u0011#\u0001\u0003R\u0019I!1D\u0001\u0002\u0002#\u0005!1\u000b\u0005\u0007uZ!\tAa\u001b\t\u0013\tEa#!A\u0005F\tM\u0001\"\u0003B7-\u0005\u0005I\u0011\u0011B8\u0011%\u0011\u0019HFA\u0001\n\u0003\u0013)\bC\u0005\u0003~Y\t\t\u0011\"\u0003\u0003\u0000\u00191\u0011\u0011C\u0001A\u0003'A!\"a\u000e\u001d\u0005+\u0007I\u0011AA\u001d\u0011)\t9\u0005\bB\tB\u0003%\u00111\b\u0005\u000b\u0003\u0013b\"Q3A\u0005\u0002\u0005-\u0003BCA*9\tE\t\u0015!\u0003\u0002N!Q\u0011Q\u000b\u000f\u0003\u0016\u0004%\t!a\u0016\t\u0015\u0005\u0015DD!E!\u0002\u0013\tI\u0006\u0003\u0004{9\u0011\u0005\u0011q\r\u0005\b\u0003cbB\u0011AA:\u0011\u001d\t9\t\bC\u0001\u0003\u0013C\u0011\"!%\u001d\u0003\u0003%\t!a%\t\u0013\u0005mE$%A\u0005\u0002\u0005u\u0005\"CAZ9E\u0005I\u0011AA[\u0011%\tI\fHI\u0001\n\u0003\tY\fC\u0005\u0002@r\t\t\u0011\"\u0011\u0002B\"I\u00111\u001b\u000f\u0002\u0002\u0013\u0005\u0011Q\u001b\u0005\n\u0003;d\u0012\u0011!C\u0001\u0003?D\u0011\"a;\u001d\u0003\u0003%\t%!<\t\u0013\u0005mH$!A\u0005\u0002\u0005u\b\"\u0003B\u00049\u0005\u0005I\u0011\tB\u0005\u0011%\u0011i\u0001HA\u0001\n\u0003\u0012y\u0001C\u0005\u0003\u0012q\t\t\u0011\"\u0011\u0003\u0014!I!Q\u0003\u000f\u0002\u0002\u0013\u0005#qC\u0004\n\u0005\u000f\u000b\u0011\u0011!E\u0001\u0005\u00133\u0011\"!\u0005\u0002\u0003\u0003E\tAa#\t\ri$D\u0011\u0001BJ\u0011%\u0011\t\u0002NA\u0001\n\u000b\u0012\u0019\u0002C\u0005\u0003nQ\n\t\u0011\"!\u0003\u0016\"I!1\u000f\u001b\u0002\u0002\u0013\u0005%Q\u0014\u0005\n\u0005{\"\u0014\u0011!C\u0005\u0005\u007f2aA!+\u0002\u0001\n-\u0006B\u0003BWu\tU\r\u0011\"\u0001\u00030\"Q!q\u0017\u001e\u0003\u0012\u0003\u0006IA!-\t\riTD\u0011\u0001B]\u0011\u001d\u0011yL\u000fC\u0001\u0005\u0003DqA!7;\t\u0003\u0011Y\u000eC\u0005\u0002\u0012j\n\t\u0011\"\u0001\u0003`\"I\u00111\u0014\u001e\u0012\u0002\u0013\u0005!1\u001d\u0005\n\u0003\u007fS\u0014\u0011!C!\u0003\u0003D\u0011\"a5;\u0003\u0003%\t!!6\t\u0013\u0005u'(!A\u0005\u0002\t\u001d\b\"CAvu\u0005\u0005I\u0011IAw\u0011%\tYPOA\u0001\n\u0003\u0011Y\u000fC\u0005\u0003\bi\n\t\u0011\"\u0011\u0003p\"I!Q\u0002\u001e\u0002\u0002\u0013\u0005#q\u0002\u0005\n\u0005#Q\u0014\u0011!C!\u0005'A\u0011B!\u0006;\u0003\u0003%\tEa=\b\u0013\t]\u0018!!A\t\u0002\teh!\u0003BU\u0003\u0005\u0005\t\u0012\u0001B~\u0011\u0019QH\n\"\u0001\u0003\u0000\"I!\u0011\u0003'\u0002\u0002\u0013\u0015#1\u0003\u0005\n\u0005[b\u0015\u0011!CA\u0007\u0003A\u0011Ba\u001dM\u0003\u0003%\ti!\u0002\t\u0013\tuD*!A\u0005\n\t}d!\u0002:f\u0001\r-\u0001BCB\u0007%\n\u0005\t\u0015!\u0003\u0004\u0010!Q11\u0004*\u0003\u0002\u0003\u0006Ia!\b\t\u0015\r\u0015\"K!A!\u0002\u0013\u00199\u0003\u0003\u0006\u0004.I\u0013\t\u0011)A\u0005\u0007_AaA\u001f*\u0005\u0002\ru\u0002bBB.%\u0012\u00051Q\f\u0005\b\u0007w\u0013F\u0011BB_\u0011\u001d\u0019)N\u0015C\u0005\u0007/Dqaa;S\t\u0013\u0019i\u000fC\u0004\u0004~J#Iaa@\t\u000f\u0011}!\u000b\"\u0003\u0005\"!91Q *\u0005\n\u0011E\u0002b\u0002C\u001f%\u0012%Aq\b\u0005\b\t\u0013\u0012F\u0011\u0002C&\u0011\u001d!\u0019F\u0015C\u0005\t+Bq\u0001b\u001aS\t\u0013!I\u0007C\u0004\u0005tI#I\u0001\"\u001e\u000235\u000b\u0017\u000e\u001c2pqN+G/\u00169eCR,\u0007+\u001a:g_JlWM\u001d\u0006\u0003M\u001e\fa!\\3uQ>$'B\u00015j\u0003\u0011QW.\u00199\u000b\u0005)\\\u0017!\u00026b[\u0016\u001c(B\u00017n\u0003\u0019\t\u0007/Y2iK*\ta.A\u0002pe\u001e\u001c\u0001\u0001\u0005\u0002r\u00035\tQMA\rNC&d'm\u001c=TKR,\u0006\u000fZ1uKB+'OZ8s[\u0016\u00148CA\u0001u!\t)\b0D\u0001w\u0015\u00059\u0018!B:dC2\f\u0017BA=w\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012\u0001]\u0001\u0007\u0019>;u)\u0012*\u0016\u0003y\u00042a`A\u0003\u001b\t\t\tAC\u0002\u0002\u00045\fQa\u001d7gi)LA!a\u0002\u0002\u0002\t1Aj\\4hKJ\fq\u0001T(H\u000f\u0016\u0013\u0006EA\nNC&d'm\u001c=Va\u0012\fG/\u001a*fgVdGo\u0005\u0002\u0006i&\u001aQ\u0001\b\u0004\u0003)5\u000b\u0017\u000e\u001c2pqV\u0003H-\u0019;f\r\u0006LG.\u001e:f'!aB/!\u0006\u0002\u001a\u0005}\u0001cAA\f\u000b5\t\u0011\u0001E\u0002v\u00037I1!!\bw\u0005\u001d\u0001&o\u001c3vGR\u0004B!!\t\u000229!\u00111EA\u0017\u001d\u0011\t)#a\u000b\u000e\u0005\u0005\u001d\"bAA\u0015_\u00061AH]8pizJ\u0011a^\u0005\u0004\u0003_1\u0018a\u00029bG.\fw-Z\u0005\u0005\u0003g\t)D\u0001\u0007TKJL\u0017\r\\5{C\ndWMC\u0002\u00020Y\f\u0011\"\\1jY\n|\u00070\u00133\u0016\u0005\u0005m\u0002\u0003BA\u001f\u0003\u0007j!!a\u0010\u000b\u0007\u0005\u0005s-\u0001\u0003nC&d\u0017\u0002BA#\u0003\u007f\u0011\u0011#\u00168qCJ\u001cX\rZ'bS2\u0014w\u000e_%e\u0003)i\u0017-\u001b7c_bLE\rI\u0001\nKb\u001cW\r\u001d;j_:,\"!!\u0014\u0011\t\u0005\u0005\u0012qJ\u0005\u0005\u0003#\n)DA\u0005UQJ|w/\u00192mK\u0006QQ\r_2faRLwN\u001c\u0011\u0002\u000bA\fGo\u00195\u0016\u0005\u0005e\u0003#B;\u0002\\\u0005}\u0013bAA/m\n1q\n\u001d;j_:\u0004B!!\u0010\u0002b%!\u00111MA \u0005m1\u0016\r\\5eCR,G-T1jY\n|\u0007\u0010U1uG\"|%M[3di\u00061\u0001/\u0019;dQ\u0002\"\u0002\"!\u001b\u0002l\u00055\u0014q\u000e\t\u0004\u0003/a\u0002bBA\u001cG\u0001\u0007\u00111\b\u0005\b\u0003\u0013\u001a\u0003\u0019AA'\u0011\u001d\t)f\ta\u0001\u00033\naAZ5mi\u0016\u0014H\u0003BA;\u0003\u0007\u0003R!^A.\u0003o\u0002B!!\u001f\u0002\u00005\u0011\u00111\u0010\u0006\u0004\u0003{:\u0017\u0001B2pe\u0016LA!!!\u0002|\tQ\u0001K]8qKJ$\u0018.Z:\t\u000f\u0005\u0015E\u00051\u0001\u0002x\u0005!\u0012mY2faR\f'\r\\3Qe>\u0004XM\u001d;jKN\f\u0011#Y:NC&d'm\u001c=TKR,%O]8s+\t\tY\t\u0005\u0003\u0002z\u00055\u0015\u0002BAH\u0003w\u0012\u0001bU3u\u000bJ\u0014xN]\u0001\u0005G>\u0004\u0018\u0010\u0006\u0005\u0002j\u0005U\u0015qSAM\u0011%\t9D\nI\u0001\u0002\u0004\tY\u0004C\u0005\u0002J\u0019\u0002\n\u00111\u0001\u0002N!I\u0011Q\u000b\u0014\u0011\u0002\u0003\u0007\u0011\u0011L\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\tyJ\u000b\u0003\u0002<\u0005\u00056FAAR!\u0011\t)+a,\u000e\u0005\u0005\u001d&\u0002BAU\u0003W\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u00055f/\u0001\u0006b]:|G/\u0019;j_:LA!!-\u0002(\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011q\u0017\u0016\u0005\u0003\u001b\n\t+\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005u&\u0006BA-\u0003C\u000bQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAAb!\u0011\t)-a4\u000e\u0005\u0005\u001d'\u0002BAe\u0003\u0017\fA\u0001\\1oO*\u0011\u0011QZ\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002R\u0006\u001d'AB*ue&tw-\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002XB\u0019Q/!7\n\u0007\u0005mgOA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002b\u0006\u001d\bcA;\u0002d&\u0019\u0011Q\u001d<\u0003\u0007\u0005s\u0017\u0010C\u0005\u0002j2\n\t\u00111\u0001\u0002X\u0006\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!a<\u0011\r\u0005E\u0018q_Aq\u001b\t\t\u0019PC\u0002\u0002vZ\f!bY8mY\u0016\u001cG/[8o\u0013\u0011\tI0a=\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003\u007f\u0014)\u0001E\u0002v\u0005\u0003I1Aa\u0001w\u0005\u001d\u0011un\u001c7fC:D\u0011\"!;/\u0003\u0003\u0005\r!!9\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u0003\u0007\u0014Y\u0001C\u0005\u0002j>\n\t\u00111\u0001\u0002X\u0006A\u0001.Y:i\u0007>$W\r\u0006\u0002\u0002X\u0006AAo\\*ue&tw\r\u0006\u0002\u0002D\u00061Q-];bYN$B!a@\u0003\u001a!I\u0011\u0011\u001e\u001a\u0002\u0002\u0003\u0007\u0011\u0011\u001d\u0002\u0015\u001b\u0006LGNY8y+B$\u0017\r^3Tk\u000e\u001cWm]:\u0014\u0011\u0019!\u0018QCA\r\u0003?)\"A!\t\u0011\t\t\r\"QF\u0007\u0003\u0005KQAAa\n\u0003*\u0005)Qn\u001c3fY*\u0019!1F5\u0002\u000f5\f\u0017\u000e\u001c2pq&!!q\u0006B\u0013\u0005%i\u0015-\u001b7c_bLE\r\u0006\u0003\u00034\tU\u0002cAA\f\r!9\u0011qG\u0005A\u0002\t\u0005B\u0003\u0002B\u001a\u0005sA\u0011\"a\u000e\u000b!\u0003\u0005\rA!\t\u0016\u0005\tu\"\u0006\u0002B\u0011\u0003C#B!!9\u0003B!I\u0011\u0011\u001e\b\u0002\u0002\u0003\u0007\u0011q\u001b\u000b\u0005\u0003\u007f\u0014)\u0005C\u0005\u0002jB\t\t\u00111\u0001\u0002bR!\u00111\u0019B%\u0011%\tI/EA\u0001\u0002\u0004\t9\u000e\u0006\u0003\u0002\u0000\n5\u0003\"CAu)\u0005\u0005\t\u0019AAq\u0003Qi\u0015-\u001b7c_b,\u0006\u000fZ1uKN+8mY3tgB\u0019\u0011q\u0003\f\u0014\u000bY\u0011)F!\u0019\u0011\u0011\t]#Q\fB\u0011\u0005gi!A!\u0017\u000b\u0007\tmc/A\u0004sk:$\u0018.\\3\n\t\t}#\u0011\f\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\f\u0004\u0003\u0002B2\u0005Sj!A!\u001a\u000b\t\t\u001d\u00141Z\u0001\u0003S>LA!a\r\u0003fQ\u0011!\u0011K\u0001\u0006CB\u0004H.\u001f\u000b\u0005\u0005g\u0011\t\bC\u0004\u00028e\u0001\rA!\t\u0002\u000fUt\u0017\r\u001d9msR!!q\u000fB=!\u0015)\u00181\fB\u0011\u0011%\u0011YHGA\u0001\u0002\u0004\u0011\u0019$A\u0002yIA\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"A!!\u0011\t\u0005\u0015'1Q\u0005\u0005\u0005\u000b\u000b9M\u0001\u0004PE*,7\r^\u0001\u0015\u001b\u0006LGNY8y+B$\u0017\r^3GC&dWO]3\u0011\u0007\u0005]AgE\u00035\u0005\u001b\u0013\t\u0007\u0005\u0007\u0003X\t=\u00151HA'\u00033\nI'\u0003\u0003\u0003\u0012\ne#!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8ogQ\u0011!\u0011\u0012\u000b\t\u0003S\u00129J!'\u0003\u001c\"9\u0011qG\u001cA\u0002\u0005m\u0002bBA%o\u0001\u0007\u0011Q\n\u0005\b\u0003+:\u0004\u0019AA-)\u0011\u0011yJa*\u0011\u000bU\fYF!)\u0011\u0013U\u0014\u0019+a\u000f\u0002N\u0005e\u0013b\u0001BSm\n1A+\u001e9mKNB\u0011Ba\u001f9\u0003\u0003\u0005\r!!\u001b\u0003)5\u000b\u0017\u000e\u001c2pqV\u0003H-\u0019;f%\u0016\u001cX\u000f\u001c;t'\u0019QD/!\u0007\u0002 \u00059!/Z:vYR\u001cXC\u0001BY!\u0019\t\tCa-\u0002\u0016%!!QWA\u001b\u0005\r\u0019V-]\u0001\te\u0016\u001cX\u000f\u001c;tAQ!!1\u0018B_!\r\t9B\u000f\u0005\b\u0005[k\u0004\u0019\u0001BY\u0003\u001d)\b\u000fZ1uK\u0012,\"Aa1\u0011\u0011\t\u0015'Q\u001aB\u0011\u0005'tAAa2\u0003JB\u0019\u0011Q\u0005<\n\u0007\t-g/\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0005\u001f\u0014\tNA\u0002NCBT1Aa3w!\u0011\tiD!6\n\t\t]\u0017q\b\u0002\u0016\u001b\u0006LGNY8y+B$\u0017\r^3SKN\u0004xN\\:f\u0003)qw\u000e^+qI\u0006$X\rZ\u000b\u0003\u0005;\u0004\u0002B!2\u0003N\u0006m\u00121\u0012\u000b\u0005\u0005w\u0013\t\u000fC\u0005\u0003.\u0002\u0003\n\u00111\u0001\u00032V\u0011!Q\u001d\u0016\u0005\u0005c\u000b\t\u000b\u0006\u0003\u0002b\n%\b\"CAu\t\u0006\u0005\t\u0019AAl)\u0011\tyP!<\t\u0013\u0005%h)!AA\u0002\u0005\u0005H\u0003BAb\u0005cD\u0011\"!;H\u0003\u0003\u0005\r!a6\u0015\t\u0005}(Q\u001f\u0005\n\u0003ST\u0015\u0011!a\u0001\u0003C\fA#T1jY\n|\u00070\u00169eCR,'+Z:vYR\u001c\bcAA\f\u0019N)AJ!@\u0003bAA!q\u000bB/\u0005c\u0013Y\f\u0006\u0002\u0003zR!!1XB\u0002\u0011\u001d\u0011ik\u0014a\u0001\u0005c#Baa\u0002\u0004\nA)Q/a\u0017\u00032\"I!1\u0010)\u0002\u0002\u0003\u0007!1X\n\u0003%R\f!b]3sS\u0006d\u0017N_3s!\u0011\u0019\tba\u0006\u000e\u0005\rM!bAB\u000bO\u0006!!n]8o\u0013\u0011\u0019Iba\u0005\u0003#5\u000b\u0017\u000e\u001c2pqN+'/[1mSj,'/\u0001\bnC&d'm\u001c=NC:\fw-\u001a:\u0011\t\r}1\u0011E\u0007\u0003\u0005SIAaa\t\u0003*\tqQ*Y5mE>DX*\u00198bO\u0016\u0014\u0018aE:vEN\u001c'/\u001b9uS>tW*\u00198bO\u0016\u0014\b\u0003BB\u0010\u0007SIAaa\u000b\u0003*\t\u00192+\u001e2tGJL\u0007\u000f^5p]6\u000bg.Y4fe\u0006\u0001R.Y5mE>D\u0018\n\u001a$bGR|'/\u001f\t\u0005\u0007c\u00199D\u0004\u0003\u0003$\rM\u0012\u0002BB\u001b\u0005K\t\u0011\"T1jY\n|\u00070\u00133\n\t\re21\b\u0002\b\r\u0006\u001cGo\u001c:z\u0015\u0011\u0019)D!\n\u0015\u0015\r}2\u0011IB\"\u0007\u000b\u001a9\u0005\u0005\u0002r%\"91QB,A\u0002\r=\u0001bBB\u000e/\u0002\u00071Q\u0004\u0005\b\u0007K9\u0006\u0019AB\u0014\u0011\u001d\u0019ic\u0016a\u0001\u0007_A3aVB&!\u0011\u0019iea\u0016\u000e\u0005\r=#\u0002BB)\u0007'\na!\u001b8kK\u000e$(BAB+\u0003\u001dQ\u0017m[1si\u0006LAa!\u0017\u0004P\t1\u0011J\u001c6fGR\fq\"\u001e9eCR,W*Y5mE>DXm\u001d\u000b\t\u0007?\u001aYi!&\u0004 B11\u0011MB8\u0007gj!aa\u0019\u000b\t\r\u00154qM\u0001\naV\u0014G.[:iKJT1a^B5\u0015\u0011\tiha\u001b\u000b\u0005\r5\u0014a\u0002:fC\u000e$xN]\u0005\u0005\u0007c\u001a\u0019GA\u0003T\u001b>tw\u000eE\u0002\u0004vir1aa\u001e\u0001\u001d\u0011\u0019Ih!#\u000f\t\rm4q\u0011\b\u0005\u0007{\u001a)I\u0004\u0003\u0004\u0000\r\re\u0002BA\u0013\u0007\u0003K\u0011A\\\u0005\u0003Y6L!A[6\n\u0005!L\u0017B\u00014h\u0011\u001d\u0019i\t\u0017a\u0001\u0007\u001f\u000ba\"\\1jY\n|\u0007pU3tg&|g\u000e\u0005\u0003\u0004 \rE\u0015\u0002BBJ\u0005S\u0011a\"T1jY\n|\u0007pU3tg&|g\u000eC\u0004\u0004\u0018b\u0003\ra!'\u0002#5\f\u0017\u000e\u001c2pqN+GOU3rk\u0016\u001cH\u000f\u0005\u0003\u0002>\rm\u0015\u0002BBO\u0003\u007f\u0011\u0011#T1jY\n|\u0007pU3u%\u0016\fX/Z:u\u0011\u001d\u0019\t\u000b\u0017a\u0001\u0007G\u000bAbY1qC\nLG.\u001b;jKN\u0004bA!2\u0004&\u000e%\u0016\u0002BBT\u0005#\u00141aU3u!\u0011\u0019Yk!.\u000f\t\r56\u0011\u0017\b\u0005\u0007s\u001ay+C\u0002\u0002~\u001dLAaa-\u0002|\u0005!2)\u00199bE&d\u0017\u000e^=JI\u0016tG/\u001b4jKJLAaa.\u0004:\n!2)\u00199bE&d\u0017\u000e^=JI\u0016tG/\u001b4jKJTAaa-\u0002|\u0005iQ\u000f\u001d3bi\u0016l\u0015-\u001b7c_b$Bba0\u0004D\u000e\u00157qYBf\u0007'\u0004ba!\u0019\u0004p\r\u0005\u0007cAB;\u000b!91QR-A\u0002\r=\u0005bBA\u001c3\u0002\u0007!\u0011\u0005\u0005\b\u0007\u0013L\u0006\u0019AA\u001e\u0003E)h\u000e]1sg\u0016$W*Y5mE>D\u0018\n\u001a\u0005\b\u0003+J\u0006\u0019ABg!\u0011\tida4\n\t\rE\u0017q\b\u0002\u0013\u001b\u0006LGNY8y!\u0006$8\r[(cU\u0016\u001cG\u000fC\u0004\u0004\"f\u0003\raa)\u0002%U\u0004H-\u0019;f'V\u00147o\u0019:jaRLwN\u001c\u000b\u000b\u0007\u007f\u001bIna7\u0004`\u000e\u0005\bbBA\u001c5\u0002\u0007!\u0011\u0005\u0005\b\u0007;T\u0006\u0019AA0\u000391\u0018\r\\5eCR,G\rU1uG\"Dqa!$[\u0001\u0004\u0019y\tC\u0004\u0004dj\u0003\ra!:\u0002\u001d5,7o]1hK6\u000bg.Y4feB!1qDBt\u0013\u0011\u0019IO!\u000b\u0003\u001d5+7o]1hK6\u000bg.Y4fe\u0006\tR\u000f\u001d3bi\u0016l\u0015-\u001b7c_b\u0004\u0016\r\u001e5\u0015\u001d\r}6q^By\u0007g\u001c)pa>\u0004z\"9\u0011qG.A\u0002\t\u0005\u0002bBBe7\u0002\u0007\u00111\b\u0005\b\u0007;\\\u0006\u0019AA0\u0011\u001d\u0019ii\u0017a\u0001\u0007\u001fCqAa\u000b\\\u0001\u0004\u0019)\u000fC\u0004\u0004|n\u0003\r!a@\u0002)M,\b\u000f]8siNC\u0017M]3e\u001b\u0006LGNY8y\u0003M\t\u0007\u000f\u001d7z!\u0006\u0014XM\u001c;JIV\u0003H-\u0019;f))!\t\u0001\"\u0004\u0005\u0010\u0011mAQ\u0004\t\bk\u0012\rAq\u0001C\u0004\u0013\r!)A\u001e\u0002\n\rVt7\r^5p]F\u0002BAa\t\u0005\n%!A1\u0002B\u0013\u0005-i\u0015-\u001b7c_b\u0004\u0016\r\u001e5\t\u000f\u0005]B\f1\u0001\u0003\"!9A\u0011\u0003/A\u0002\u0011M\u0011aE7bs\n,\u0007+\u0019:f]RLE-\u00169eCR,\u0007#B;\u0002\\\u0011U\u0001\u0003BA\u001f\t/IA\u0001\"\u0007\u0002@\tq\u0001+\u0019:f]RLE-\u00169eCR,\u0007bBBG9\u0002\u00071q\u0012\u0005\b\u0007wd\u0006\u0019AA\u0000\u0003=\t\u0007\u000f\u001d7z\u001d\u0006lW-\u00169eCR,GC\u0002C\u0001\tG!y\u0003C\u0004\u0005&u\u0003\r\u0001b\n\u0002\u001f5\f\u0017PY3OC6,W\u000b\u001d3bi\u0016\u0004R!^A.\tS\u0001B!!\u0010\u0005,%!AQFA \u0005)q\u0015-\\3Va\u0012\fG/\u001a\u0005\b\u0007\u001bk\u0006\u0019ABH))!\t\u0001b\r\u00056\u0011eB1\b\u0005\b\u0003oq\u0006\u0019\u0001B\u0011\u0011\u001d!9D\u0018a\u0001\t+\ta\u0002]1sK:$\u0018\nZ+qI\u0006$X\rC\u0004\u0004\u000ez\u0003\raa$\t\u000f\rmh\f1\u0001\u0002\u0000\u0006\tr-\u001a;NKN\u001c\u0018mZ3NC:\fw-\u001a:\u0015\u0011\u0011\u0005C1\tC#\t\u000f\u0002ba!\u0019\u0004p\r\u0015\bbBB~?\u0002\u0007\u0011q \u0005\b\u0003oy\u0006\u0019\u0001B\u0011\u0011\u001d\u0019ii\u0018a\u0001\u0007\u001f\u000b1#\u001e9eCR,W*Y5mE>D(+[4iiN$\u0002ba0\u0005N\u0011=C\u0011\u000b\u0005\b\u0003o\u0001\u0007\u0019\u0001B\u0011\u0011\u001d\u0019i\u000e\u0019a\u0001\u0003?Bqa!$a\u0001\u0004\u0019y)A\nde\u0016\fG/Z%oE>D\u0018J\u001a(fK\u0012,G\r\u0006\u0004\u0005X\u0011}C1\r\t\u0007\u0007C\u001ay\u0007\"\u0017\u0011\u0007U$Y&C\u0002\u0005^Y\u0014A!\u00168ji\"9A\u0011M1A\u0002\u0011\u001d\u0011\u0001D3ySN$\u0018N\\4QCRD\u0007b\u0002C3C\u0002\u00071qR\u0001\bg\u0016\u001c8/[8o\u0003-\u0019'/Z1uK&s'm\u001c=\u0015\u0011\u0011]C1\u000eC8\tcBq\u0001\"\u001cc\u0001\u0004\ty0\u0001\u0004fq&\u001cHo\u001d\u0005\b\tC\u0012\u0007\u0019\u0001C\u0004\u0011\u001d!)G\u0019a\u0001\u0007\u001f\u000b\u0001#[:B'f\u001cH/Z7NC&d'm\u001c=\u0015\t\u0005}Hq\u000f\u0005\b\u0005W\u0019\u0007\u0019ABs\u0001")
public class MailboxSetUpdatePerformer {
    private final MailboxSerializer serializer;
    private final MailboxManager mailboxManager;
    private final SubscriptionManager subscriptionManager;
    private final MailboxId.Factory mailboxIdFactory;

    public SMono<MailboxUpdateResults> updateMailboxes(MailboxSession mailboxSession, MailboxSetRequest mailboxSetRequest, Set<Refined<String, string.Uri>> capabilities) {
        SFlux qual$1 = SFlux$.MODULE$.fromIterable((Iterable)mailboxSetRequest.update().getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$));
        Function1 & Serializable x$1 = (Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                UnparsedMailboxId unparsedMailboxId = (UnparsedMailboxId)tuple2._1();
                MailboxPatchObject patch = (MailboxPatchObject)tuple2._2();
                if (unparsedMailboxId != null) {
                    UnparsedMailboxId unparsedMailboxId2 = unparsedMailboxId;
                    if (patch != null) {
                        MailboxPatchObject mailboxPatchObject = patch;
                        return ((SMono)MailboxGet$.MODULE$.parse($this.mailboxIdFactory, unparsedMailboxId2).fold((Function1 & Serializable)e -> SMono$.MODULE$.just((Object)new MailboxUpdateFailure(unparsedMailboxId2, (Throwable)e, (Option<ValidatedMailboxPatchObject>)None$.MODULE$)), (Function1 & Serializable)mailboxId -> this.updateMailbox(mailboxSession, (MailboxId)mailboxId, unparsedMailboxId2, mailboxPatchObject, capabilities))).onErrorResume((Function1 & Serializable)e -> SMono$.MODULE$.just((Object)new MailboxUpdateFailure(unparsedMailboxId2, (Throwable)e, (Option<ValidatedMailboxPatchObject>)None$.MODULE$)));
                    }
                }
            }
            throw new MatchError((Object)tuple2);
        };
        int x$2 = 5;
        int x$3 = qual$1.flatMap$default$3();
        boolean x$4 = qual$1.flatMap$default$4();
        return qual$1.flatMap((Function1)x$1, 5, x$3, x$4).collectSeq().map((Function1)MailboxSetUpdatePerformer$MailboxUpdateResults$.MODULE$);
    }

    private SMono<MailboxUpdateResult> updateMailbox(MailboxSession mailboxSession, MailboxId mailboxId, UnparsedMailboxId unparsedMailboxId, MailboxPatchObject patch, Set<Refined<String, string.Uri>> capabilities) {
        return (SMono)patch.validate(this.mailboxIdFactory, this.serializer, capabilities, mailboxSession).fold((Function1 & Serializable)e -> SMono$.MODULE$.error((Throwable)e), (Function1 & Serializable)validatedPatch -> {
            boolean supportSharedMailbox = capabilities.contains((Object)new Refined((Object)CapabilityIdentifier$.MODULE$.JAMES_SHARES()));
            return this.getMessageManager(supportSharedMailbox, mailboxId, mailboxSession).flatMap((Function1 & Serializable)messageManager -> this.updateMailboxRights(mailboxId, (ValidatedMailboxPatchObject)validatedPatch, mailboxSession).then(this.updateSubscription(mailboxId, (ValidatedMailboxPatchObject)validatedPatch, mailboxSession, (MessageManager)messageManager)).then(this.updateMailboxPath(mailboxId, unparsedMailboxId, (ValidatedMailboxPatchObject)validatedPatch, mailboxSession, (MessageManager)messageManager, supportSharedMailbox)));
        });
    }

    private SMono<MailboxUpdateResult> updateSubscription(MailboxId mailboxId, ValidatedMailboxPatchObject validatedPatch, MailboxSession mailboxSession, MessageManager messageManager) {
        return (SMono)validatedPatch.isSubscribedUpdate().map((Function1 & Serializable)isSubscribedUpdate -> SMono$.MODULE$.fromCallable(() -> {
            MailboxSetUpdatePerformer.$anonfun$updateSubscription$2(this, messageManager, mailboxSession, isSubscribedUpdate);
            return BoxedUnit.UNIT;
        }).then(SMono$.MODULE$.just((Object)new MailboxUpdateSuccess(mailboxId))).subscribeOn(ReactorUtils.BLOCKING_CALL_WRAPPER)).getOrElse((Function0 & Serializable)() -> SMono$.MODULE$.just((Object)new MailboxUpdateSuccess(mailboxId)));
    }

    private SMono<MailboxUpdateResult> updateMailboxPath(MailboxId mailboxId, UnparsedMailboxId unparsedMailboxId, ValidatedMailboxPatchObject validatedPatch, MailboxSession mailboxSession, MessageManager mailbox, boolean supportSharedMailbox) {
        if (validatedPatch.shouldUpdateMailboxPath()) {
            return SMono$.MODULE$.fromCallable(() -> {
                Product product;
                try {
                    MailboxPath newPath;
                    if (this.isASystemMailbox(mailbox) && !"INBOX".equalsIgnoreCase(mailbox.getMailboxPath().getName())) {
                        throw new SystemMailboxChangeException(mailboxId);
                    }
                    if (validatedPatch.parentIdUpdate().flatMap((Function1 & Serializable)x$3 -> x$3.newId()).contains((Object)mailboxId)) {
                        throw new LoopInMailboxGraphException(mailboxId);
                    }
                    MailboxPath oldPath = mailbox.getMailboxPath();
                    Object object = !oldPath.equals((Object)(newPath = (MailboxPath)this.applyParentIdUpdate(mailboxId, validatedPatch.parentIdUpdate(), mailboxSession, supportSharedMailbox).andThen(this.applyNameUpdate(validatedPatch.nameUpdate(), mailboxSession)).apply((Object)oldPath))) ? $this.mailboxManager.renameMailbox(mailboxId, newPath, MailboxManager.RenameOption.RENAME_SUBSCRIPTIONS, mailboxSession) : BoxedUnit.UNIT;
                    product = new MailboxUpdateSuccess(mailboxId);
                }
                catch (Exception e) {
                    product = new MailboxUpdateFailure(unparsedMailboxId, e, (Option<ValidatedMailboxPatchObject>)new Some((Object)validatedPatch));
                }
                return product;
            }).subscribeOn(ReactorUtils.BLOCKING_CALL_WRAPPER).flatMap((Function1 & Serializable)updateResult -> this.createInboxIfNeeded(mailbox.getMailboxPath(), mailboxSession).then(SMono$.MODULE$.just(updateResult)));
        }
        return SMono$.MODULE$.just((Object)new MailboxUpdateSuccess(mailboxId));
    }

    private Function1<MailboxPath, MailboxPath> applyParentIdUpdate(MailboxId mailboxId, Option<ParentIdUpdate> maybeParentIdUpdate, MailboxSession mailboxSession, boolean supportSharedMailbox) {
        return (Function1)maybeParentIdUpdate.map((Function1 & Serializable)parentIdUpdate -> this.applyParentIdUpdate(mailboxId, (ParentIdUpdate)parentIdUpdate, mailboxSession, supportSharedMailbox)).getOrElse((Function0 & Serializable)() -> (Function1 & Serializable)x -> x);
    }

    private Function1<MailboxPath, MailboxPath> applyNameUpdate(Option<NameUpdate> maybeNameUpdate, MailboxSession mailboxSession) {
        return (Function1 & Serializable)originalPath -> (MailboxPath)maybeNameUpdate.map((Function1 & Serializable)nameUpdate -> {
            Option originalParentPath = ((IterableOps)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(originalPath.getHierarchyLevels(mailboxSession.getPathDelimiter())).asScala().reverse()).drop(1)).headOption();
            return (MailboxPath)originalParentPath.map((Function1 & Serializable)x$4 -> x$4.child(nameUpdate.newName(), mailboxSession.getPathDelimiter())).getOrElse((Function0 & Serializable)() -> MailboxPath.forUser((Username)mailboxSession.getUser(), (String)nameUpdate.newName()));
        }).getOrElse((Function0 & Serializable)() -> originalPath);
    }

    private Function1<MailboxPath, MailboxPath> applyParentIdUpdate(MailboxId mailboxId, ParentIdUpdate parentIdUpdate, MailboxSession mailboxSession, boolean supportSharedMailbox) {
        return (Function1 & Serializable)originalPath -> {
            String currentName = originalPath.getName(mailboxSession.getPathDelimiter());
            return (MailboxPath)parentIdUpdate.newId().map((Function1 & Serializable)id -> {
                Duration x$1;
                SMono qual$1 = SFlux$.MODULE$.fromPublisher((Publisher)$this.mailboxManager.search(MailboxQuery.builder().userAndNamespaceFrom(originalPath).expression((MailboxNameExpression)new PrefixedWildcard(originalPath.getName() + mailboxSession.getPathDelimiter())).build(), MailboxManager.MailboxSearchFetchType.Minimal, mailboxSession)).filter((Function1 & Serializable)child -> BoxesRunTime.boxToBoolean((boolean)MailboxSetUpdatePerformer.$anonfun$applyParentIdUpdate$6(id, child))).hasElements();
                boolean createsALoop = BoxesRunTime.unboxToBoolean((Object)qual$1.block(x$1 = qual$1.block$default$1()));
                if (createsALoop) {
                    throw new LoopInMailboxGraphException(mailboxId);
                }
                MailboxPath parentPath = $this.mailboxManager.getMailbox(id, mailboxSession).getMailboxPath();
                if (!parentPath.belongsTo(mailboxSession) && !supportSharedMailbox) {
                    throw new MailboxNotFoundException(id);
                }
                return parentPath.child(currentName, mailboxSession.getPathDelimiter());
            }).getOrElse((Function0 & Serializable)() -> MailboxPath.forUser((Username)originalPath.getUser(), (String)currentName));
        };
    }

    private SMono<MessageManager> getMessageManager(boolean supportSharedMailbox, MailboxId mailboxId, MailboxSession mailboxSession) {
        return SMono$.MODULE$.apply(this.mailboxManager.getMailboxReactive(mailboxId, mailboxSession)).filterWhen(MailboxSetMethod$.MODULE$.assertCapabilityIfSharedMailbox(mailboxSession, mailboxId, supportSharedMailbox));
    }

    private SMono<MailboxUpdateResult> updateMailboxRights(MailboxId mailboxId, ValidatedMailboxPatchObject validatedPatch, MailboxSession mailboxSession) {
        SMono resetOperation = (SMono)validatedPatch.rightsReset().map((Function1 & Serializable)sharedWithResetUpdate -> SMono$.MODULE$.fromCallable(() -> {
            this.mailboxManager.setRights(mailboxId, sharedWithResetUpdate.rights().toMailboxAcl().asJava(), mailboxSession);
            return BoxedUnit.UNIT;
        }).then()).getOrElse((Function0 & Serializable)() -> SMono$.MODULE$.empty());
        SFlux qual$1 = SFlux$.MODULE$.fromIterable(validatedPatch.rightsPartialUpdates());
        Function1 & Serializable x$1 = (Function1 & Serializable)partialUpdate -> SMono$.MODULE$.fromCallable(() -> {
            this.mailboxManager.applyRightsCommand(mailboxId, partialUpdate.asACLCommand(), mailboxSession);
            return BoxedUnit.UNIT;
        }).then(SMono$.MODULE$.apply((Publisher)ReactorUtils.logAsMono(() -> AuditTrail.entry().username(() -> mailboxSession.getUser().asString()).protocol("JMAP").action("Mailbox/set update").parameters(() -> ImmutableMap.of((Object)"loggedInUser", (Object)OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(mailboxSession.getLoggedInUser())).map((Function1 & Serializable)x$5 -> x$5.asString()).getOrElse((Function0 & Serializable)() -> ""), (Object)"delegator", (Object)mailboxSession.getUser().asString(), (Object)"delegatee", (Object)partialUpdate.entryKey().getName(), (Object)"mailboxId", (Object)mailboxId.serialize(), (Object)"rights", (Object)partialUpdate.rights().asJava().serialize())).log("JMAP mailbox shared."))));
        int x$2 = 5;
        int x$3 = qual$1.flatMap$default$3();
        boolean x$4 = qual$1.flatMap$default$4();
        SMono partialUpdatesOperation = qual$1.flatMap((Function1)x$1, 5, x$3, x$4).then();
        return SFlux$.MODULE$.merge((Seq)new .colon.colon((Object)resetOperation, (List)new .colon.colon((Object)partialUpdatesOperation, (List)Nil$.MODULE$)), SFlux$.MODULE$.merge$default$2(), SFlux$.MODULE$.merge$default$3()).then().then(SMono$.MODULE$.just((Object)new MailboxUpdateSuccess(mailboxId))).subscribeOn(ReactorUtils.BLOCKING_CALL_WRAPPER);
    }

    private SMono<BoxedUnit> createInboxIfNeeded(MailboxPath existingPath, MailboxSession session) {
        if (!existingPath.getName().equalsIgnoreCase("INBOX")) {
            return SMono$.MODULE$.empty();
        }
        return SMono$.MODULE$.apply(this.mailboxManager.mailboxExists(existingPath, session)).flatMap((Function1 & Serializable)exists -> this.createInbox(Predef$.MODULE$.Boolean2boolean(exists), existingPath, session));
    }

    private SMono<BoxedUnit> createInbox(boolean exists, MailboxPath existingPath, MailboxSession session) {
        if (exists) {
            return SMono$.MODULE$.empty();
        }
        return SMono$.MODULE$.apply(this.mailboxManager.createMailboxReactive(existingPath, session)).then();
    }

    private boolean isASystemMailbox(MessageManager mailbox) {
        return Role.from((String)mailbox.getMailboxPath().getName()).isPresent();
    }

    public static final /* synthetic */ void $anonfun$updateSubscription$2(MailboxSetUpdatePerformer $this, MessageManager messageManager$1, MailboxSession mailboxSession$3, IsSubscribedUpdate isSubscribedUpdate$1) {
        boolean isOwner = messageManager$1.getMailboxPath().belongsTo(mailboxSession$3);
        boolean shouldSubscribe = BoxesRunTime.unboxToBoolean((Object)isSubscribedUpdate$1.isSubscribed().map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)((IsSubscribed)x$2).value())).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> isOwner));
        if (shouldSubscribe) {
            $this.subscriptionManager.subscribe(mailboxSession$3, messageManager$1.getMailboxPath());
            return;
        }
        $this.subscriptionManager.unsubscribe(mailboxSession$3, messageManager$1.getMailboxPath());
    }

    public static final /* synthetic */ boolean $anonfun$applyParentIdUpdate$6(MailboxId id$1, MailboxMetaData child) {
        return child.getId().equals(id$1);
    }

    @Inject
    public MailboxSetUpdatePerformer(MailboxSerializer serializer, MailboxManager mailboxManager, SubscriptionManager subscriptionManager, MailboxId.Factory mailboxIdFactory) {
        this.serializer = serializer;
        this.mailboxManager = mailboxManager;
        this.subscriptionManager = subscriptionManager;
        this.mailboxIdFactory = mailboxIdFactory;
    }

    public static class MailboxUpdateFailure
    implements MailboxUpdateResult,
    Product,
    Serializable {
        private final UnparsedMailboxId mailboxId;
        private final Throwable exception;
        private final Option<ValidatedMailboxPatchObject> patch;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public UnparsedMailboxId mailboxId() {
            return this.mailboxId;
        }

        public Throwable exception() {
            return this.exception;
        }

        public Option<ValidatedMailboxPatchObject> patch() {
            return this.patch;
        }

        public Option<Properties> filter(Properties acceptableProperties) {
            return new Some(this.patch().map((Function1 & Serializable)x$1 -> x$1.updatedProperties().intersect(acceptableProperties)).getOrElse((Function0 & Serializable)() -> acceptableProperties));
        }

        public SetError asMailboxSetError() {
            Throwable throwable = this.exception();
            if (throwable instanceof MailboxNotFoundException) {
                MailboxNotFoundException mailboxNotFoundException = (MailboxNotFoundException)throwable;
                MailboxSetUpdatePerformer$.MODULE$.org$apache$james$jmap$method$MailboxSetUpdatePerformer$$LOGGER().info("Can't update mailbox: Mailbox not found: {}", (Object)mailboxNotFoundException.getMessage());
                return SetError$.MODULE$.notFound(mailboxNotFoundException.getMessage());
            }
            if (throwable instanceof MailboxNameException) {
                MailboxNameException mailboxNameException = (MailboxNameException)throwable;
                MailboxSetUpdatePerformer$.MODULE$.org$apache$james$jmap$method$MailboxSetUpdatePerformer$$LOGGER().info("Invalid mailbox name: {}", (Object)mailboxNameException.getMessage());
                return SetError$.MODULE$.invalidArguments(mailboxNameException.getMessage(), this.filter(Properties$.MODULE$.apply((Seq<Refined<String, boolean.Not<collection.Empty>>>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Refined[]{new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"name")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"parentId")).value()))}))));
            }
            if (throwable instanceof MailboxExistsException) {
                MailboxExistsException mailboxExistsException = (MailboxExistsException)throwable;
                MailboxSetUpdatePerformer$.MODULE$.org$apache$james$jmap$method$MailboxSetUpdatePerformer$$LOGGER().info("Mailbox already exists: {}", (Object)mailboxExistsException.getMessage());
                return SetError$.MODULE$.invalidArguments(mailboxExistsException.getMessage(), this.filter(Properties$.MODULE$.apply((Seq<Refined<String, boolean.Not<collection.Empty>>>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Refined[]{new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"name")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"parentId")).value()))}))));
            }
            if (throwable instanceof UnsupportedPropertyUpdatedException) {
                UnsupportedPropertyUpdatedException unsupportedPropertyUpdatedException = (UnsupportedPropertyUpdatedException)throwable;
                MailboxSetUpdatePerformer$.MODULE$.org$apache$james$jmap$method$MailboxSetUpdatePerformer$$LOGGER().info("Unsupported properties in Mailbox/set update: {}", (Object)unsupportedPropertyUpdatedException.getMessage());
                return SetError$.MODULE$.invalidArguments(new Refined((Object)unsupportedPropertyUpdatedException.property()) + " property do not exist thus cannot be updated", (Option<Properties>)new Some((Object)Properties$.MODULE$.apply((Seq<Refined<String, boolean.Not<collection.Empty>>>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Refined[]{new Refined((Object)unsupportedPropertyUpdatedException.property())}))));
            }
            if (throwable instanceof InvalidUpdateException) {
                InvalidUpdateException invalidUpdateException = (InvalidUpdateException)throwable;
                MailboxSetUpdatePerformer$.MODULE$.org$apache$james$jmap$method$MailboxSetUpdatePerformer$$LOGGER().info("Invalid update in Mailbox/set update: {}", (Object)invalidUpdateException.getMessage());
                return SetError$.MODULE$.invalidArguments(String.valueOf(invalidUpdateException.cause()), (Option<Properties>)new Some((Object)Properties$.MODULE$.apply((Seq<Refined<String, boolean.Not<collection.Empty>>>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Refined[]{new Refined((Object)invalidUpdateException.property())}))));
            }
            if (throwable instanceof ServerSetPropertyException) {
                ServerSetPropertyException serverSetPropertyException = (ServerSetPropertyException)throwable;
                MailboxSetUpdatePerformer$.MODULE$.org$apache$james$jmap$method$MailboxSetUpdatePerformer$$LOGGER().info("Unsupported server-set properties in Mailbox/set update: {}", (Object)serverSetPropertyException.getMessage());
                return SetError$.MODULE$.invalidArguments("Can not modify server-set properties", (Option<Properties>)new Some((Object)Properties$.MODULE$.apply((Seq<Refined<String, boolean.Not<collection.Empty>>>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Refined[]{new Refined((Object)serverSetPropertyException.property())}))));
            }
            if (throwable instanceof InvalidPropertyException) {
                InvalidPropertyException invalidPropertyException = (InvalidPropertyException)throwable;
                MailboxSetUpdatePerformer$.MODULE$.org$apache$james$jmap$method$MailboxSetUpdatePerformer$$LOGGER().info("Invalid properties in Mailbox/set update: {}", (Object)invalidPropertyException.getMessage());
                return SetError$.MODULE$.invalidPatch(String.valueOf(invalidPropertyException.cause()));
            }
            if (throwable instanceof InvalidPatchException) {
                InvalidPatchException invalidPatchException = (InvalidPatchException)throwable;
                MailboxSetUpdatePerformer$.MODULE$.org$apache$james$jmap$method$MailboxSetUpdatePerformer$$LOGGER().info("Unsupported patch in Mailbox/set update: {}", (Object)invalidPatchException.getMessage());
                return SetError$.MODULE$.invalidPatch(String.valueOf(invalidPatchException.cause()));
            }
            if (throwable instanceof SystemMailboxChangeException) {
                SystemMailboxChangeException systemMailboxChangeException = (SystemMailboxChangeException)throwable;
                MailboxSetUpdatePerformer$.MODULE$.org$apache$james$jmap$method$MailboxSetUpdatePerformer$$LOGGER().info("Attempt to update a system mailbox was rejected: {}", (Object)systemMailboxChangeException.getMessage());
                return SetError$.MODULE$.invalidArguments("Invalid change to a system mailbox", this.filter(Properties$.MODULE$.apply((Seq<Refined<String, boolean.Not<collection.Empty>>>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Refined[]{new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"name")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"parentId")).value()))}))));
            }
            if (throwable instanceof LoopInMailboxGraphException) {
                LoopInMailboxGraphException loopInMailboxGraphException = (LoopInMailboxGraphException)throwable;
                MailboxSetUpdatePerformer$.MODULE$.org$apache$james$jmap$method$MailboxSetUpdatePerformer$$LOGGER().info("Attempt to create a loop in mailbox graph was rejected: {}", (Object)loopInMailboxGraphException.getMessage());
                return SetError$.MODULE$.invalidArguments("A mailbox parentId property can not be set to itself or one of its child", (Option<Properties>)new Some((Object)Properties$.MODULE$.apply((Seq<Refined<String, boolean.Not<collection.Empty>>>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Refined[]{new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"parentId")).value()))}))));
            }
            if (throwable instanceof InsufficientRightsException) {
                InsufficientRightsException insufficientRightsException = (InsufficientRightsException)throwable;
                MailboxSetUpdatePerformer$.MODULE$.org$apache$james$jmap$method$MailboxSetUpdatePerformer$$LOGGER().info("Attempt to set a mailbox while having insufficient rights was rejected: {}", (Object)insufficientRightsException.getMessage());
                return SetError$.MODULE$.forbidden("Invalid change to a delegated mailbox", SetError$.MODULE$.forbidden$default$2());
            }
            if (throwable instanceof IllegalArgumentException) {
                IllegalArgumentException illegalArgumentException = (IllegalArgumentException)throwable;
                MailboxSetUpdatePerformer$.MODULE$.org$apache$james$jmap$method$MailboxSetUpdatePerformer$$LOGGER().info("Illegal argument in Mailbox/set update", (Throwable)illegalArgumentException);
                return SetError$.MODULE$.invalidArguments(illegalArgumentException.getMessage(), (Option<Properties>)None$.MODULE$);
            }
            if (throwable instanceof DifferentDomainException) {
                DifferentDomainException differentDomainException = (DifferentDomainException)throwable;
                MailboxSetUpdatePerformer$.MODULE$.org$apache$james$jmap$method$MailboxSetUpdatePerformer$$LOGGER().info("Invalid arguments in Mailbox/set update", (Throwable)differentDomainException);
                return SetError$.MODULE$.invalidArguments("Invalid arguments in Mailbox/set update: different domains", (Option<Properties>)None$.MODULE$);
            }
            MailboxSetUpdatePerformer$.MODULE$.org$apache$james$jmap$method$MailboxSetUpdatePerformer$$LOGGER().error("Failed to update mailbox", throwable);
            return SetError$.MODULE$.serverFail(throwable.getMessage());
        }

        public MailboxUpdateFailure copy(UnparsedMailboxId mailboxId, Throwable exception, Option<ValidatedMailboxPatchObject> patch) {
            return new MailboxUpdateFailure(mailboxId, exception, patch);
        }

        public UnparsedMailboxId copy$default$1() {
            return this.mailboxId();
        }

        public Throwable copy$default$2() {
            return this.exception();
        }

        public Option<ValidatedMailboxPatchObject> copy$default$3() {
            return this.patch();
        }

        public String productPrefix() {
            return "MailboxUpdateFailure";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.mailboxId();
                }
                case 1: {
                    return this.exception();
                }
                case 2: {
                    return this.patch();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof MailboxUpdateFailure;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "mailboxId";
                }
                case 1: {
                    return "exception";
                }
                case 2: {
                    return "patch";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof MailboxUpdateFailure)) return false;
            boolean bl = true;
            if (!bl) return false;
            MailboxUpdateFailure mailboxUpdateFailure = (MailboxUpdateFailure)x$1;
            UnparsedMailboxId unparsedMailboxId = this.mailboxId();
            UnparsedMailboxId unparsedMailboxId2 = mailboxUpdateFailure.mailboxId();
            if (unparsedMailboxId == null) {
                if (unparsedMailboxId2 != null) {
                    return false;
                }
            } else if (!((Object)unparsedMailboxId).equals(unparsedMailboxId2)) return false;
            Throwable throwable = this.exception();
            Throwable throwable2 = mailboxUpdateFailure.exception();
            if (throwable == null) {
                if (throwable2 != null) {
                    return false;
                }
            } else if (!throwable.equals(throwable2)) return false;
            Option<ValidatedMailboxPatchObject> option = this.patch();
            Option<ValidatedMailboxPatchObject> option2 = mailboxUpdateFailure.patch();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            if (!mailboxUpdateFailure.canEqual(this)) return false;
            return true;
        }

        public MailboxUpdateFailure(UnparsedMailboxId mailboxId, Throwable exception, Option<ValidatedMailboxPatchObject> patch) {
            this.mailboxId = mailboxId;
            this.exception = exception;
            this.patch = patch;
            Product.$init$((Product)this);
        }
    }

    public static interface MailboxUpdateResult {
    }

    public static class MailboxUpdateResults
    implements Product,
    Serializable {
        private final Seq<MailboxUpdateResult> results;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public Seq<MailboxUpdateResult> results() {
            return this.results;
        }

        public Map<MailboxId, MailboxUpdateResponse> updated() {
            return ((IterableOnceOps)this.results().flatMap((Function1 & Serializable)result -> {
                MailboxUpdateResult mailboxUpdateResult = result;
                if (mailboxUpdateResult instanceof MailboxUpdateSuccess) {
                    MailboxUpdateSuccess mailboxUpdateSuccess = (MailboxUpdateSuccess)mailboxUpdateResult;
                    return new Some((Object)new Tuple2((Object)mailboxUpdateSuccess.mailboxId(), (Object)MailboxSetResponse$.MODULE$.empty()));
                }
                return None$.MODULE$;
            })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }

        public Map<UnparsedMailboxId, SetError> notUpdated() {
            return ((IterableOnceOps)this.results().flatMap((Function1 & Serializable)result -> {
                MailboxUpdateResult mailboxUpdateResult = result;
                if (mailboxUpdateResult instanceof MailboxUpdateFailure) {
                    MailboxUpdateFailure mailboxUpdateFailure = (MailboxUpdateFailure)mailboxUpdateResult;
                    return new Some((Object)new Tuple2((Object)mailboxUpdateFailure.mailboxId(), (Object)mailboxUpdateFailure.asMailboxSetError()));
                }
                return None$.MODULE$;
            })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }

        public MailboxUpdateResults copy(Seq<MailboxUpdateResult> results) {
            return new MailboxUpdateResults(results);
        }

        public Seq<MailboxUpdateResult> copy$default$1() {
            return this.results();
        }

        public String productPrefix() {
            return "MailboxUpdateResults";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.results();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof MailboxUpdateResults;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "results";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof MailboxUpdateResults)) return false;
            boolean bl = true;
            if (!bl) return false;
            MailboxUpdateResults mailboxUpdateResults = (MailboxUpdateResults)x$1;
            Seq<MailboxUpdateResult> seq = this.results();
            Seq<MailboxUpdateResult> seq2 = mailboxUpdateResults.results();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            if (!mailboxUpdateResults.canEqual(this)) return false;
            return true;
        }

        public MailboxUpdateResults(Seq<MailboxUpdateResult> results) {
            this.results = results;
            Product.$init$((Product)this);
        }
    }

    public static class MailboxUpdateSuccess
    implements MailboxUpdateResult,
    Product,
    Serializable {
        private final MailboxId mailboxId;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public MailboxId mailboxId() {
            return this.mailboxId;
        }

        public MailboxUpdateSuccess copy(MailboxId mailboxId) {
            return new MailboxUpdateSuccess(mailboxId);
        }

        public MailboxId copy$default$1() {
            return this.mailboxId();
        }

        public String productPrefix() {
            return "MailboxUpdateSuccess";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.mailboxId();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof MailboxUpdateSuccess;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "mailboxId";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof MailboxUpdateSuccess)) return false;
            boolean bl = true;
            if (!bl) return false;
            MailboxUpdateSuccess mailboxUpdateSuccess = (MailboxUpdateSuccess)x$1;
            MailboxId mailboxId = this.mailboxId();
            MailboxId mailboxId2 = mailboxUpdateSuccess.mailboxId();
            if (mailboxId == null) {
                if (mailboxId2 != null) {
                    return false;
                }
            } else if (!mailboxId.equals(mailboxId2)) return false;
            if (!mailboxUpdateSuccess.canEqual(this)) return false;
            return true;
        }

        public MailboxUpdateSuccess(MailboxId mailboxId) {
            this.mailboxId = mailboxId;
            Product.$init$((Product)this);
        }
    }
}

