/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.service;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableSet;
import java.time.Clock;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import org.apache.james.core.Username;
import org.apache.james.json.DTOModule;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.server.task.json.dto.TaskDTO;
import org.apache.james.server.task.json.dto.TaskDTOModule;
import org.apache.james.task.Task;
import org.apache.james.task.TaskExecutionDetails;
import org.apache.james.task.TaskType;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CreateMissingParentsTask
implements Task {
    private static final Username USERNAME = Username.of((String)"createMissingParentsTask");
    static final TaskType TASK_TYPE = TaskType.of((String)"CreateMissingParentsTask");
    private final ConcurrentLinkedQueue<MailboxId> created;
    private final AtomicLong totalCreated;
    private final ConcurrentLinkedQueue<String> failures;
    private final AtomicLong totalFailure;
    private final MailboxManager mailboxManager;

    public static TaskDTOModule<CreateMissingParentsTask, CreateMissingParentsTaskDTO> module(MailboxManager mailboxManager) {
        return (TaskDTOModule)DTOModule.forDomainObject(CreateMissingParentsTask.class).convertToDTO(CreateMissingParentsTaskDTO.class).toDomainObjectConverter(dto -> new CreateMissingParentsTask(mailboxManager)).toDTOConverter((task, type) -> new CreateMissingParentsTaskDTO(type)).typeName(TASK_TYPE.asString()).withFactory(TaskDTOModule::new);
    }

    public CreateMissingParentsTask(MailboxManager mailboxManager) {
        this.mailboxManager = mailboxManager;
        this.created = new ConcurrentLinkedQueue();
        this.totalCreated = new AtomicLong(0L);
        this.failures = new ConcurrentLinkedQueue();
        this.totalFailure = new AtomicLong(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task.Result run() {
        MailboxSession session = this.mailboxManager.createSystemSession(USERNAME);
        try {
            List mailboxPaths = this.mailboxManager.list(session);
            char delimiter = session.getPathDelimiter();
            Set parentPaths = (Set)mailboxPaths.stream().filter(path -> path.hasParent(delimiter)).flatMap(path -> path.getParents(delimiter).stream()).collect(ImmutableSet.toImmutableSet());
            Task.Result result = (Task.Result)Flux.fromIterable((Iterable)parentPaths).filter(Predicate.not(mailboxPaths::contains)).flatMap(this::createMailbox, 16).reduce(Task::combine).switchIfEmpty(Mono.just((Object)Task.Result.COMPLETED)).block();
            return result;
        }
        catch (MailboxException e) {
            LOGGER.error("Error fetching mailbox paths", (Throwable)e);
            Task.Result result = Task.Result.PARTIAL;
            return result;
        }
        finally {
            this.mailboxManager.endProcessingRequest(session);
        }
    }

    private Mono<Task.Result> createMailbox(MailboxPath path) {
        MailboxSession ownerSession = this.mailboxManager.createSystemSession(path.getUser());
        return Mono.from((Publisher)this.mailboxManager.createMailboxReactive(path, ownerSession)).doOnNext(this::recordSuccess).then(Mono.just((Object)Task.Result.COMPLETED)).onErrorResume(e -> {
            LOGGER.error("Error creating missing parent mailbox: {}", (Object)path.getName(), e);
            this.recordFailure(path);
            return Mono.just((Object)Task.Result.PARTIAL);
        }).doFinally(any -> this.mailboxManager.endProcessingRequest(ownerSession));
    }

    public TaskType type() {
        return TASK_TYPE;
    }

    public Optional<TaskExecutionDetails.AdditionalInformation> details() {
        return Optional.of(AdditionalInformation.from((Set)this.created.stream().map(MailboxId::serialize).collect(ImmutableSet.toImmutableSet()), this.totalCreated.get(), (Set)this.failures.stream().collect(ImmutableSet.toImmutableSet()), this.totalFailure.get()));
    }

    private void recordSuccess(MailboxId mailboxId) {
        this.created.add(mailboxId);
        this.totalCreated.incrementAndGet();
    }

    private void recordFailure(MailboxPath mailboxPath) {
        this.failures.add(mailboxPath.asString());
        this.totalFailure.incrementAndGet();
    }

    public static class CreateMissingParentsTaskDTO
    implements TaskDTO {
        private final String type;

        public CreateMissingParentsTaskDTO(@JsonProperty(value="type") String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }
    }

    public static class AdditionalInformation
    implements TaskExecutionDetails.AdditionalInformation {
        private final Instant timestamp;
        private final Set<String> created;
        private final long totalCreated;
        private final Set<String> failures;
        private final long totalFailure;

        private static AdditionalInformation from(Set<String> created, long totalCreated, Set<String> failures, long totalFailure) {
            return new AdditionalInformation(Clock.systemUTC().instant(), created, totalCreated, failures, totalFailure);
        }

        public AdditionalInformation(Instant timestamp, Set<String> created, long totalCreated, Set<String> failures, long totalFailure) {
            this.created = created;
            this.failures = failures;
            this.totalCreated = totalCreated;
            this.totalFailure = totalFailure;
            this.timestamp = timestamp;
        }

        public Set<String> getCreated() {
            return this.created;
        }

        public long getTotalCreated() {
            return this.totalCreated;
        }

        public Set<String> getFailures() {
            return this.failures;
        }

        public long getTotalFailure() {
            return this.totalFailure;
        }

        public Instant timestamp() {
            return this.timestamp;
        }
    }
}

