/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.memory;

import java.util.Objects;

public class MemoryException
extends RuntimeException {
    private final long timestamp;
    private static final long VERSION = 1L;

    public MemoryException(String message) {
        super(message);
        this.timestamp = System.currentTimeMillis();
    }

    public MemoryException(String message, long timeStamp) {
        super(message);
        this.timestamp = timeStamp;
    }

    public MemoryException(String message, Throwable cause) {
        super(message, cause);
        this.timestamp = System.currentTimeMillis();
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public boolean equals(Object obj) {
        return obj instanceof MemoryException && Objects.equals(this.getMessage(), ((MemoryException)obj).getMessage()) && Objects.equals(this.getTimestamp(), ((MemoryException)obj).getTimestamp());
    }

    public int hashCode() {
        return Objects.hash(this.getMessage(), this.getTimestamp());
    }

    @Override
    public String toString() {
        return "MemoryException{message='" + this.getMessage() + "', timestamp=" + this.getTimestamp() + "}";
    }
}

