/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process.window.function.rank;

import org.apache.iotdb.db.queryengine.execution.operator.process.window.function.rank.RankWindowFunction;
import org.apache.iotdb.db.queryengine.execution.operator.process.window.partition.Partition;
import org.apache.tsfile.block.column.ColumnBuilder;

public class NTileFunction
extends RankWindowFunction {
    private final int nChannel;

    public NTileFunction(int nChannel) {
        this.nChannel = nChannel;
    }

    @Override
    public void transform(Partition partition, ColumnBuilder builder, int index, boolean isNewPeerGroup, int peerGroupCount) {
        if (partition.isNull(this.nChannel, index)) {
            builder.appendNull();
        } else {
            long n = partition.getLong(this.nChannel, index);
            builder.writeLong(this.bucket(n, index, partition.getPositionCount()) + 1L);
        }
    }

    private long bucket(long buckets, int index, int count) {
        if ((long)count < buckets) {
            return index;
        }
        long rowsPerBucket = (long)count / buckets;
        long remainderRows = (long)count % buckets;
        if ((long)index < (rowsPerBucket + 1L) * remainderRows) {
            return (long)index / (rowsPerBucket + 1L);
        }
        return ((long)index - remainderRows) / rowsPerBucket;
    }

    @Override
    public boolean needPeerGroup() {
        return false;
    }
}

