/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped.hash;

import java.io.IOException;
import java.io.InputStream;
import org.apache.tsfile.utils.BytesUtils;

public class XxHash64 {
    private static final long PRIME64_1 = -7046029288634856825L;
    private static final long PRIME64_2 = -7046029288634856825L;
    private static final long PRIME64_3 = 1609587929392839161L;
    private static final long PRIME64_4 = -8796714831421723037L;
    private static final long PRIME64_5 = 2870177450012600261L;
    private static final long DEFAULT_SEED = 0L;
    private final long seed;
    private static final int BUFFER_ADDRESS;
    private final byte[] buffer = new byte[32];
    private int bufferSize;
    private long bodyLength;
    private long v1;
    private long v2;
    private long v3;
    private long v4;
    public static final long TRUE_XX_HASH;
    public static final long FALSE_XX_HASH;

    public XxHash64() {
        this(0L);
    }

    public XxHash64(long seed) {
        this.seed = seed;
        this.v1 = seed + -7046029288634856825L + -7046029288634856825L;
        this.v2 = seed + -7046029288634856825L;
        this.v3 = seed;
        this.v4 = seed - -7046029288634856825L;
    }

    public XxHash64 update(byte[] data) {
        return this.update(data, 0, data.length);
    }

    public XxHash64 update(byte[] data, int offset, int length) {
        this.updateHash(data, BUFFER_ADDRESS + offset, length);
        return this;
    }

    public long hash() {
        long hash = this.bodyLength > 0L ? this.computeBody() : this.seed + 2870177450012600261L;
        return XxHash64.updateTail(hash += this.bodyLength + (long)this.bufferSize, this.buffer, BUFFER_ADDRESS, 0, this.bufferSize);
    }

    private long computeBody() {
        long hash = Long.rotateLeft(this.v1, 1) + Long.rotateLeft(this.v2, 7) + Long.rotateLeft(this.v3, 12) + Long.rotateLeft(this.v4, 18);
        hash = XxHash64.update(hash, this.v1);
        hash = XxHash64.update(hash, this.v2);
        hash = XxHash64.update(hash, this.v3);
        hash = XxHash64.update(hash, this.v4);
        return hash;
    }

    private void updateHash(byte[] base, int address, int length) {
        int index;
        if (this.bufferSize > 0) {
            index = Math.min(32 - this.bufferSize, length);
            System.arraycopy(base, address, this.buffer, BUFFER_ADDRESS + this.bufferSize, index);
            this.bufferSize += index;
            address += index;
            length -= index;
            if (this.bufferSize == 32) {
                this.updateBody(this.buffer, BUFFER_ADDRESS, this.bufferSize);
                this.bufferSize = 0;
            }
        }
        if (length >= 32) {
            index = this.updateBody(base, address, length);
            address += index;
            length -= index;
        }
        if (length > 0) {
            System.arraycopy(base, address, this.buffer, BUFFER_ADDRESS, length);
            this.bufferSize = length;
        }
    }

    private int updateBody(byte[] base, int address, int length) {
        int remaining;
        for (remaining = length; remaining >= 32; remaining -= 32) {
            this.v1 = XxHash64.mix(this.v1, BytesUtils.bytesToLongFromOffset((byte[])base, (int)8, (int)address));
            this.v2 = XxHash64.mix(this.v2, BytesUtils.bytesToLongFromOffset((byte[])base, (int)8, (int)(address + 8)));
            this.v3 = XxHash64.mix(this.v3, BytesUtils.bytesToLongFromOffset((byte[])base, (int)8, (int)(address + 16)));
            this.v4 = XxHash64.mix(this.v4, BytesUtils.bytesToLongFromOffset((byte[])base, (int)8, (int)(address + 24)));
            address += 32;
        }
        int index = length - remaining;
        this.bodyLength += (long)index;
        return index;
    }

    public static long hash(long value) {
        return XxHash64.hash(0L, value);
    }

    public static long hash(long seed, long value) {
        long hash = seed + 2870177450012600261L + 8L;
        hash = XxHash64.updateTail(hash, value);
        hash = XxHash64.finalShuffle(hash);
        return hash;
    }

    public static long hash(InputStream in) throws IOException {
        return XxHash64.hash(0L, in);
    }

    public static long hash(long seed, InputStream in) throws IOException {
        XxHash64 hash = new XxHash64(seed);
        byte[] buffer = new byte[8192];
        int length;
        while ((length = in.read(buffer)) != -1) {
            hash.update(buffer, 0, length);
        }
        return hash.hash();
    }

    public static long hash(byte[] data) {
        return XxHash64.hash(data, 0, data.length);
    }

    public static long hash(long seed, byte[] data) {
        return XxHash64.hash(seed, data, 0, data.length);
    }

    public static long hash(byte[] data, int offset, int length) {
        return XxHash64.hash(0L, data, offset, length);
    }

    public static long hash(long seed, byte[] data, int offset, int length) {
        int address = BUFFER_ADDRESS + offset;
        long hash = length >= 32 ? XxHash64.updateBody(seed, data, address, length) : seed + 2870177450012600261L;
        int index = length & 0xFFFFFFE0;
        return XxHash64.updateTail(hash += (long)length, data, address, index, length);
    }

    private static long updateTail(long hash, byte[] base, int address, int index, int length) {
        while (index <= length - 8) {
            hash = XxHash64.updateTail(hash, BytesUtils.bytesToLongFromOffset((byte[])base, (int)8, (int)(address + index)));
            index += 8;
        }
        if (index <= length - 4) {
            hash = XxHash64.updateTail(hash, BytesUtils.bytesToInt((byte[])base, (int)(address + index)));
            index += 4;
        }
        while (index < length) {
            hash = XxHash64.updateTail(hash, base[address + index]);
            ++index;
        }
        hash = XxHash64.finalShuffle(hash);
        return hash;
    }

    private static long updateBody(long seed, byte[] base, int address, int length) {
        long v1 = seed + -7046029288634856825L + -7046029288634856825L;
        long v2 = seed + -7046029288634856825L;
        long v3 = seed;
        long v4 = seed - -7046029288634856825L;
        for (int remaining = length; remaining >= 32; remaining -= 32) {
            v1 = XxHash64.mix(v1, BytesUtils.bytesToLongFromOffset((byte[])base, (int)8, (int)address));
            v2 = XxHash64.mix(v2, BytesUtils.bytesToLongFromOffset((byte[])base, (int)8, (int)(address + 8)));
            v3 = XxHash64.mix(v3, BytesUtils.bytesToLongFromOffset((byte[])base, (int)8, (int)(address + 16)));
            v4 = XxHash64.mix(v4, BytesUtils.bytesToLongFromOffset((byte[])base, (int)8, (int)(address + 24)));
            address += 32;
        }
        long hash = Long.rotateLeft(v1, 1) + Long.rotateLeft(v2, 7) + Long.rotateLeft(v3, 12) + Long.rotateLeft(v4, 18);
        hash = XxHash64.update(hash, v1);
        hash = XxHash64.update(hash, v2);
        hash = XxHash64.update(hash, v3);
        hash = XxHash64.update(hash, v4);
        return hash;
    }

    private static long mix(long current, long value) {
        return Long.rotateLeft(current + value * -7046029288634856825L, 31) * -7046029288634856825L;
    }

    private static long update(long hash, long value) {
        long temp = hash ^ XxHash64.mix(0L, value);
        return temp * -7046029288634856825L + -8796714831421723037L;
    }

    private static long updateTail(long hash, long value) {
        long temp = hash ^ XxHash64.mix(0L, value);
        return Long.rotateLeft(temp, 27) * -7046029288634856825L + -8796714831421723037L;
    }

    private static long updateTail(long hash, int value) {
        long unsigned = (long)value & 0xFFFFFFFFL;
        long temp = hash ^ unsigned * -7046029288634856825L;
        return Long.rotateLeft(temp, 23) * -7046029288634856825L + 1609587929392839161L;
    }

    private static long updateTail(long hash, byte value) {
        int unsigned = value & 0xFF;
        long temp = hash ^ (long)unsigned * 2870177450012600261L;
        return Long.rotateLeft(temp, 11) * -7046029288634856825L;
    }

    private static long finalShuffle(long hash) {
        hash ^= hash >>> 33;
        hash *= -7046029288634856825L;
        hash ^= hash >>> 29;
        hash *= 1609587929392839161L;
        hash ^= hash >>> 32;
        return hash;
    }

    static {
        TRUE_XX_HASH = XxHash64.hash(1L);
        FALSE_XX_HASH = XxHash64.hash(0L);
        BUFFER_ADDRESS = 0;
    }
}

