/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.write.record;

import java.util.ArrayList;
import java.util.List;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.file.metadata.PlainDeviceID;
import org.apache.tsfile.utils.StringContainer;
import org.apache.tsfile.write.record.datapoint.DataPoint;

public class TSRecord {
    public long time;
    public String deviceId;
    public List<DataPoint> dataPointList = new ArrayList<DataPoint>();

    public TSRecord(long timestamp, String deviceId) {
        this.time = timestamp;
        this.deviceId = deviceId;
    }

    public TSRecord(long timestamp, IDeviceID deviceId) {
        this.time = timestamp;
        this.deviceId = ((PlainDeviceID)deviceId).toStringID();
    }

    public void setTime(long timestamp) {
        this.time = timestamp;
    }

    public TSRecord addTuple(DataPoint tuple) {
        this.dataPointList.add(tuple);
        return this;
    }

    public String toString() {
        StringContainer sc = new StringContainer(" ");
        sc.addTail("{device id:", this.deviceId, "time:", this.time, ",data:[");
        for (DataPoint tuple : this.dataPointList) {
            sc.addTail(tuple);
        }
        sc.addTail("]}");
        return sc.toString();
    }
}

