/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.store;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.iotdb.confignode.procedure.Procedure;
import org.apache.iotdb.confignode.procedure.store.IProcedureFactory;
import org.apache.tsfile.utils.PublicBAOS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcedureWAL {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcedureWAL.class);
    private IProcedureFactory procedureFactory;
    private Path walFilePath;

    public ProcedureWAL(Path walFilePath, IProcedureFactory procedureFactory) {
        this.walFilePath = walFilePath;
        this.procedureFactory = procedureFactory;
    }

    public void save(Procedure procedure) throws IOException {
        File walTmp = new File(this.walFilePath + ".tmp");
        Path walTmpPath = walTmp.toPath();
        Files.deleteIfExists(walTmpPath);
        Files.createFile(walTmpPath, new FileAttribute[0]);
        try (FileOutputStream fos = new FileOutputStream(walTmp);
             FileChannel channel = fos.getChannel();
             PublicBAOS publicBAOS = new PublicBAOS();
             DataOutputStream dataOutputStream = new DataOutputStream((OutputStream)publicBAOS);){
            procedure.serialize(dataOutputStream);
            channel.write(ByteBuffer.wrap(publicBAOS.getBuf(), 0, publicBAOS.size()));
            channel.force(true);
            fos.getFD().sync();
        }
        Files.deleteIfExists(this.walFilePath);
        Files.move(walTmpPath, this.walFilePath, new CopyOption[0]);
    }
}

