/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.read.reader.chunk;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.tsfile.common.conf.TSFileDescriptor;
import org.apache.tsfile.encoding.decoder.Decoder;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.enums.TSEncoding;
import org.apache.tsfile.read.common.BatchData;
import org.apache.tsfile.read.filter.basic.Filter;
import org.apache.tsfile.read.reader.IChunkReader;
import org.apache.tsfile.read.reader.IPageReader;

public abstract class AbstractChunkReader
implements IChunkReader {
    protected final Decoder defaultTimeDecoder = Decoder.getDecoderByType(TSEncoding.valueOf(TSFileDescriptor.getInstance().getConfig().getTimeEncoder()), TSDataType.INT64);
    protected final long readStopTime;
    protected final Filter queryFilter;
    protected final List<IPageReader> pageReaderList = new LinkedList<IPageReader>();

    protected AbstractChunkReader(long readStopTime, Filter filter) {
        this.readStopTime = readStopTime;
        this.queryFilter = filter;
    }

    @Override
    public boolean hasNextSatisfiedPage() {
        return !this.pageReaderList.isEmpty();
    }

    @Override
    public BatchData nextPageData() throws IOException {
        if (this.pageReaderList.isEmpty()) {
            throw new IOException("No more page");
        }
        return this.pageReaderList.remove(0).getAllSatisfiedPageData();
    }

    @Override
    public void close() {
    }

    @Override
    public List<IPageReader> loadPageReaderList() {
        return this.pageReaderList;
    }
}

