/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.tx.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import org.apache.ignite3.internal.hlc.ClockService;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.placementdriver.PlacementDriver;
import org.apache.ignite3.internal.placementdriver.ReplicaMeta;
import org.apache.ignite3.internal.replicator.ReplicationGroupId;
import org.apache.ignite3.internal.util.ExceptionUtils;
import org.apache.ignite3.lang.ErrorGroups;
import org.apache.ignite3.tx.TransactionException;

public class PlacementDriverHelper {
    private static final IgniteLogger LOG = Loggers.forClass(PlacementDriverHelper.class);
    private static final int AWAIT_PRIMARY_REPLICA_TIMEOUT = 10;
    private final PlacementDriver placementDriver;
    private final ClockService clockService;

    public PlacementDriverHelper(PlacementDriver placementDriver, ClockService clockService) {
        this.placementDriver = placementDriver;
        this.clockService = clockService;
    }

    public CompletableFuture<ReplicaMeta> awaitPrimaryReplicaWithExceptionHandling(ReplicationGroupId partitionId) {
        HybridTimestamp timestamp = this.clockService.now();
        return this.awaitPrimaryReplicaWithExceptionHandling(partitionId, timestamp);
    }

    private CompletableFuture<ReplicaMeta> awaitPrimaryReplicaWithExceptionHandling(ReplicationGroupId partitionId, HybridTimestamp timestamp) {
        return this.placementDriver.awaitPrimaryReplica(partitionId, timestamp, 10L, TimeUnit.SECONDS).handle((primaryReplica, e) -> {
            if (e != null) {
                LOG.debug("Failed to retrieve primary replica for partition {}", partitionId, e);
                throw ExceptionUtils.withCause(TransactionException::new, ErrorGroups.Replicator.REPLICA_UNAVAILABLE_ERR, "Failed to get the primary replica [tablePartitionId=" + partitionId + ", awaitTimestamp=" + timestamp + "]", e);
            }
            return primaryReplica;
        });
    }

    public CompletableFuture<PartitionData> findPrimaryReplicas(Collection<ReplicationGroupId> partitions) {
        return this.computePrimaryReplicas(partitions, this.placementDriver::getPrimaryReplica);
    }

    public CompletableFuture<Map<String, Set<ReplicationGroupId>>> awaitPrimaryReplicas(Collection<ReplicationGroupId> partitions) {
        return this.computePrimaryReplicas(partitions, this::awaitPrimaryReplicaWithExceptionHandling).thenApply(partitionData -> partitionData.partitionsByNode);
    }

    private CompletableFuture<PartitionData> computePrimaryReplicas(Collection<ReplicationGroupId> partitions, BiFunction<ReplicationGroupId, HybridTimestamp, CompletableFuture<ReplicaMeta>> placementFunction) {
        if (partitions == null || partitions.isEmpty()) {
            return CompletableFuture.completedFuture(new PartitionData(Collections.emptyMap(), Collections.emptySet()));
        }
        HybridTimestamp timestamp = this.clockService.now();
        HashMap<ReplicationGroupId, CompletableFuture<ReplicaMeta>> primaryReplicaFutures = new HashMap<ReplicationGroupId, CompletableFuture<ReplicaMeta>>();
        for (ReplicationGroupId partitionId : partitions) {
            primaryReplicaFutures.put(partitionId, placementFunction.apply(partitionId, timestamp));
        }
        return CompletableFuture.allOf(primaryReplicaFutures.values().toArray(new CompletableFuture[0])).thenApply(v -> {
            HashMap<String, Set<ReplicationGroupId>> partitionsByNode = new HashMap<String, Set<ReplicationGroupId>>();
            HashSet<ReplicationGroupId> partitionsWithoutPrimary = new HashSet<ReplicationGroupId>();
            for (Map.Entry entry : primaryReplicaFutures.entrySet()) {
                ReplicaMeta meta = (ReplicaMeta)((CompletableFuture)entry.getValue()).join();
                ReplicationGroupId partition = (ReplicationGroupId)entry.getKey();
                if (meta != null && meta.getLeaseholder() != null) {
                    partitionsByNode.computeIfAbsent(meta.getLeaseholder(), s -> new HashSet()).add(partition);
                    continue;
                }
                partitionsWithoutPrimary.add(partition);
            }
            return new PartitionData(partitionsByNode, partitionsWithoutPrimary);
        });
    }

    public static class PartitionData {
        final Map<String, Set<ReplicationGroupId>> partitionsByNode;
        final Set<ReplicationGroupId> partitionsWithoutPrimary;

        PartitionData(Map<String, Set<ReplicationGroupId>> partitionsByNode, Set<ReplicationGroupId> partitionsWithoutPrimary) {
            this.partitionsByNode = partitionsByNode;
            this.partitionsWithoutPrimary = partitionsWithoutPrimary;
        }
    }
}

