/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.partition.replicator;

import java.util.concurrent.CompletableFuture;
import org.apache.ignite3.internal.catalog.Catalog;
import org.apache.ignite3.internal.catalog.CatalogNotFoundException;
import org.apache.ignite3.internal.catalog.CatalogService;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.schema.SchemaSyncService;

public class ReliableCatalogVersions {
    private final SchemaSyncService schemaSyncService;
    private final CatalogService catalogService;

    public ReliableCatalogVersions(SchemaSyncService schemaSyncService, CatalogService catalogService) {
        this.schemaSyncService = schemaSyncService;
        this.catalogService = catalogService;
    }

    public CompletableFuture<Integer> reliableCatalogVersionFor(HybridTimestamp ts) {
        return this.schemaSyncService.waitForMetadataCompleteness(ts).thenApply(unused -> this.catalogService.activeCatalogVersion(ts.longValue()));
    }

    public CompletableFuture<Integer> safeReliableCatalogVersionFor(HybridTimestamp ts) {
        return this.safeReliableCatalogFor(ts).thenApply(Catalog::version);
    }

    public CompletableFuture<Catalog> safeReliableCatalogFor(HybridTimestamp ts) {
        return this.schemaSyncService.waitForMetadataCompleteness(ts).thenApply(unused -> {
            try {
                return this.catalogService.activeCatalog(ts.longValue());
            }
            catch (CatalogNotFoundException e) {
                return this.catalogService.earliestCatalog();
            }
        });
    }
}

