/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.eventlog.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.ignite3.configuration.NamedListView;
import org.apache.ignite3.configuration.notifications.ConfigurationListener;
import org.apache.ignite3.internal.eventlog.api.Sink;
import org.apache.ignite3.internal.eventlog.config.schema.EventLogConfiguration;
import org.apache.ignite3.internal.eventlog.config.schema.SinkView;
import org.apache.ignite3.internal.eventlog.impl.SinkFactory;
import org.apache.ignite3.internal.eventlog.impl.SinkRegistry;
import org.jetbrains.annotations.Nullable;

class ConfigurationBasedSinkRegistry
implements SinkRegistry {
    private final EventLogConfiguration cfg;
    private final ConfigurationListener<NamedListView<SinkView>> listener = ConfigurationListener.fromNewValueConsumer(this::updateCache);
    private volatile Map<String, Sink<?>> cache;
    private volatile Map<String, Set<Sink<?>>> cacheByChannel;
    private final SinkFactory sinkFactory;

    ConfigurationBasedSinkRegistry(EventLogConfiguration cfg, SinkFactory sinkFactory) {
        this.cfg = cfg;
        this.cache = new HashMap();
        this.cacheByChannel = new HashMap();
        this.sinkFactory = sinkFactory;
    }

    @Override
    public Sink<?> getByName(String name) {
        return this.cache.get(name);
    }

    @Override
    public Set<Sink<?>> findAllByChannel(String channel) {
        return this.cacheByChannel.get(channel);
    }

    @Override
    public void start() {
        this.updateCache((NamedListView)this.cfg.sinks().value());
        this.cfg.sinks().listen(this.listener);
    }

    @Override
    public void stop() {
        this.cfg.sinks().stopListen(this.listener);
        this.clearCache();
    }

    private void updateCache(@Nullable NamedListView<SinkView> newListValue) {
        HashMap newCache = new HashMap();
        HashMap newCacheByChannel = new HashMap();
        this.clearCache();
        if (newListValue != null) {
            for (SinkView sinkView : newListValue) {
                Sink sink = this.sinkFactory.createSink(sinkView);
                newCache.put(sinkView.name(), sink);
                newCacheByChannel.computeIfAbsent(sinkView.channel(), k -> new HashSet()).add(sink);
            }
        }
        this.cache = newCache;
        this.cacheByChannel = newCacheByChannel;
    }

    private void clearCache() {
        this.cache.values().forEach(Sink::stop);
    }
}

