/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.odbc.jdbc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.internal.binary.BinaryReaderExImpl;
import org.apache.ignite.internal.binary.BinaryWriterExImpl;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcProtocolContext;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcResult;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcResultInfo;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcThinFeature;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcUtils;
import org.apache.ignite.internal.util.typedef.internal.S;

public class JdbcQueryExecuteMultipleStatementsResult
extends JdbcResult {
    private List<JdbcResultInfo> results;
    private List<List<Object>> items;
    private boolean last;
    private int txId;

    JdbcQueryExecuteMultipleStatementsResult() {
        super((byte)13);
    }

    public JdbcQueryExecuteMultipleStatementsResult(List<JdbcResultInfo> results, List<List<Object>> items, boolean last, int txId) {
        super((byte)13);
        this.results = results;
        this.items = items;
        this.last = last;
        this.txId = txId;
    }

    public List<JdbcResultInfo> results() {
        return this.results;
    }

    public List<List<Object>> items() {
        return this.items;
    }

    public boolean isLast() {
        return this.last;
    }

    public int txId() {
        return this.txId;
    }

    @Override
    public void writeBinary(BinaryWriterExImpl writer, JdbcProtocolContext protoCtx) throws BinaryObjectException {
        super.writeBinary(writer, protoCtx);
        if (this.results != null && !this.results.isEmpty()) {
            writer.writeInt(this.results.size());
            for (JdbcResultInfo r : this.results) {
                r.writeBinary(writer, protoCtx);
            }
            if (this.results.get(0).isQuery()) {
                writer.writeBoolean(this.last);
                JdbcUtils.writeItems(writer, this.items, protoCtx);
            }
        } else {
            writer.writeInt(0);
        }
        if (protoCtx.isFeatureSupported(JdbcThinFeature.TX_AWARE_QUERIES)) {
            writer.writeInt(this.txId);
        }
    }

    @Override
    public void readBinary(BinaryReaderExImpl reader, JdbcProtocolContext protoCtx) throws BinaryObjectException {
        super.readBinary(reader, protoCtx);
        int cnt = reader.readInt();
        if (cnt == 0) {
            this.results = Collections.emptyList();
        } else {
            this.results = new ArrayList<JdbcResultInfo>(cnt);
            for (int i = 0; i < cnt; ++i) {
                JdbcResultInfo r = new JdbcResultInfo();
                r.readBinary(reader, protoCtx);
                this.results.add(r);
            }
            if (this.results.get(0).isQuery()) {
                this.last = reader.readBoolean();
                this.items = JdbcUtils.readItems(reader, protoCtx);
            }
        }
        if (protoCtx.isFeatureSupported(JdbcThinFeature.TX_AWARE_QUERIES)) {
            this.txId = reader.readInt();
        }
    }

    @Override
    public String toString() {
        return S.toString(JdbcQueryExecuteMultipleStatementsResult.class, this);
    }
}

