/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.query.reducer;

import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.processors.cache.query.reducer.NodePage;

public class NodePageStream<R> {
    private final UUID nodeId;
    private final Runnable reqPages;
    private final Runnable cancelPages;
    private boolean hasRemotePages = true;
    private CompletableFuture<NodePage<R>> head = new CompletableFuture();

    public NodePageStream(UUID nodeId, Runnable reqPages, Runnable cancelPages) {
        this.nodeId = nodeId;
        this.reqPages = reqPages;
        this.cancelPages = cancelPages;
    }

    public UUID nodeId() {
        return this.nodeId;
    }

    public synchronized CompletableFuture<NodePage<R>> headPage() {
        return this.head;
    }

    public synchronized void addPage(Collection<R> data, boolean last) {
        this.head.complete(new NodePage<R>(this.nodeId, data){
            private boolean reqNext;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasNext() {
                if (!this.reqNext) {
                    NodePageStream nodePageStream = NodePageStream.this;
                    synchronized (nodePageStream) {
                        if (NodePageStream.this.hasRemotePages) {
                            NodePageStream.this.head = new CompletableFuture();
                            NodePageStream.this.reqPages.run();
                        } else {
                            NodePageStream.this.head = null;
                        }
                    }
                    this.reqNext = true;
                }
                return super.hasNext();
            }
        });
        if (last) {
            this.hasRemotePages = false;
        }
    }

    public synchronized void cancel(Throwable err) {
        if (this.closed()) {
            return;
        }
        this.head.completeExceptionally(err);
        this.cancelPages.run();
        this.hasRemotePages = false;
    }

    public synchronized boolean hasRemotePages() {
        return this.hasRemotePages;
    }

    public synchronized boolean closed() {
        return !this.hasRemotePages && this.head == null;
    }
}

