/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.extras.extended.ads_impl.whoAmI;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.util.Asn1Buffer;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.AbstractExtendedOperationFactory;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.extras.extended.whoAmI.WhoAmIRequest;
import org.apache.directory.api.ldap.extras.extended.whoAmI.WhoAmIRequestImpl;
import org.apache.directory.api.ldap.extras.extended.whoAmI.WhoAmIResponse;
import org.apache.directory.api.ldap.extras.extended.whoAmI.WhoAmIResponseImpl;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.message.ExtendedRequest;
import org.apache.directory.api.ldap.model.message.ExtendedResponse;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WhoAmIFactory
extends AbstractExtendedOperationFactory {
    private static final Logger LOG = LoggerFactory.getLogger(WhoAmIFactory.class);

    public WhoAmIFactory(LdapApiService codec) {
        super(codec, "1.3.6.1.4.1.4203.1.11.3");
    }

    public WhoAmIRequest newRequest() {
        return new WhoAmIRequestImpl();
    }

    public WhoAmIRequest newRequest(byte[] value) throws DecoderException {
        WhoAmIRequestImpl whoAmIRequest = new WhoAmIRequestImpl();
        if (value != null) {
            this.decodeValue((ExtendedRequest)whoAmIRequest, value);
        }
        return whoAmIRequest;
    }

    public WhoAmIResponse newResponse() throws DecoderException {
        return new WhoAmIResponseImpl();
    }

    public WhoAmIResponse newResponse(byte[] value) throws DecoderException {
        WhoAmIResponseImpl whoAmIResponse = new WhoAmIResponseImpl();
        if (value != null) {
            this.decodeValue((ExtendedResponse)whoAmIResponse, value);
        }
        return whoAmIResponse;
    }

    public void encodeValue(Asn1Buffer buffer, ExtendedResponse extendedResponse) {
        if (extendedResponse == null) {
            return;
        }
        extendedResponse.setResponseName(null);
        byte[] authzid = ((WhoAmIResponse)extendedResponse).getAuthzId();
        if (!Strings.isEmpty((byte[])authzid)) {
            buffer.put(authzid);
        }
    }

    public static WhoAmIResponse decode(WhoAmIResponse whoAmIResponse, byte[] data) throws DecoderException {
        if (Strings.isEmpty((byte[])data)) {
            ((WhoAmIResponseImpl)whoAmIResponse).setAuthzId(null);
        } else {
            block1 : switch (data.length) {
                case 0: 
                case 1: {
                    String msg = I18n.err((I18n)I18n.ERR_08226_AUTHZID_TOO_SHORT_MISSING_U_OR_DN, (Object[])new Object[0]);
                    LOG.error(msg);
                    throw new DecoderException(msg);
                }
                case 2: {
                    if (data[0] == 117 && data[1] == 58) {
                        ((WhoAmIResponseImpl)whoAmIResponse).setAuthzId(data);
                        ((WhoAmIResponseImpl)whoAmIResponse).setUserId(Strings.utf8ToString((byte[])data, (int)2, (int)(data.length - 2)));
                        break;
                    }
                    String msg = I18n.err((I18n)I18n.ERR_08227_AUTHZID_MUST_START_WITH_U_OR_DN, (Object[])new Object[]{Strings.utf8ToString((byte[])data)});
                    LOG.error(msg);
                    throw new DecoderException(msg);
                }
                default: {
                    switch (data[0]) {
                        case 117: {
                            if (data[1] == 58) {
                                ((WhoAmIResponseImpl)whoAmIResponse).setAuthzId(data);
                                ((WhoAmIResponseImpl)whoAmIResponse).setUserId(Strings.utf8ToString((byte[])data, (int)2, (int)(data.length - 2)));
                                break block1;
                            }
                            String msg = I18n.err((I18n)I18n.ERR_08227_AUTHZID_MUST_START_WITH_U_OR_DN, (Object[])new Object[]{Strings.utf8ToString((byte[])data)});
                            LOG.error(msg);
                            throw new DecoderException(msg);
                        }
                        case 100: {
                            if (data[1] == 110 && data[2] == 58) {
                                if (Dn.isValid((String)Strings.utf8ToString((byte[])data, (int)3, (int)(data.length - 3)))) {
                                    ((WhoAmIResponseImpl)whoAmIResponse).setAuthzId(data);
                                    try {
                                        ((WhoAmIResponseImpl)whoAmIResponse).setDn(new Dn(new String[]{Strings.utf8ToString((byte[])data, (int)3, (int)(data.length - 3))}));
                                    }
                                    catch (LdapInvalidDnException ldapInvalidDnException) {}
                                    break block1;
                                }
                                String msg = I18n.err((I18n)I18n.ERR_08227_AUTHZID_MUST_START_WITH_U_OR_DN, (Object[])new Object[]{Strings.utf8ToString((byte[])data)});
                                LOG.error(msg);
                                throw new DecoderException(msg);
                            }
                            String msg = I18n.err((I18n)I18n.ERR_08227_AUTHZID_MUST_START_WITH_U_OR_DN, (Object[])new Object[]{Strings.utf8ToString((byte[])data)});
                            LOG.error(msg);
                            throw new DecoderException(msg);
                        }
                    }
                    String msg = I18n.err((I18n)I18n.ERR_08227_AUTHZID_MUST_START_WITH_U_OR_DN, (Object[])new Object[]{Strings.utf8ToString((byte[])data)});
                    LOG.error(msg);
                    throw new DecoderException(msg);
                }
            }
        }
        return whoAmIResponse;
    }

    public void decodeValue(ExtendedResponse extendedResponse, byte[] responseValue) throws DecoderException {
        WhoAmIFactory.decode((WhoAmIResponse)extendedResponse, responseValue);
    }
}

