/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.thetacommon;

import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.theta.Sketch;
import org.apache.datasketches.theta.UpdateSketch;
import org.apache.datasketches.theta.UpdateSketchBuilder;
import org.apache.datasketches.thetacommon.BoundsOnRatiosInTupleSketchedSets;
import org.apache.datasketches.tuple.CompactSketch;
import org.apache.datasketches.tuple.Intersection;
import org.apache.datasketches.tuple.Summary;
import org.apache.datasketches.tuple.SummaryFactory;
import org.apache.datasketches.tuple.SummarySetOperations;
import org.apache.datasketches.tuple.UpdatableSketch;
import org.apache.datasketches.tuple.UpdatableSketchBuilder;
import org.apache.datasketches.tuple.adouble.DoubleSummary;
import org.apache.datasketches.tuple.adouble.DoubleSummaryFactory;
import org.apache.datasketches.tuple.adouble.DoubleSummarySetOperations;
import org.testng.Assert;
import org.testng.annotations.Test;

public class BoundsOnRatiosInTupleSketchedSetsTest {
    private final DoubleSummary.Mode umode = DoubleSummary.Mode.Sum;
    private final DoubleSummarySetOperations dsso = new DoubleSummarySetOperations();
    private final DoubleSummaryFactory factory = new DoubleSummaryFactory(this.umode);
    private final UpdateSketchBuilder thetaBldr = UpdateSketch.builder();
    private final UpdatableSketchBuilder<Double, DoubleSummary> tupleBldr = new UpdatableSketchBuilder((SummaryFactory)this.factory);
    private final Double constSummary = 1.0;

    @Test
    public void checkNormalReturns1() {
        int i;
        UpdatableSketch skA = this.tupleBldr.build();
        UpdatableSketch skC = this.tupleBldr.build();
        int uA = 10000;
        int uC = 100000;
        for (i = 0; i < 10000; ++i) {
            skA.update((long)i, (Object)this.constSummary);
        }
        for (i = 0; i < 100000; ++i) {
            skC.update((long)(i + 5000), (Object)this.constSummary);
        }
        Intersection inter = new Intersection((SummarySetOperations)this.dsso);
        inter.intersect((org.apache.datasketches.tuple.Sketch)skA);
        inter.intersect((org.apache.datasketches.tuple.Sketch)skC);
        CompactSketch skB = inter.getResult();
        double est = BoundsOnRatiosInTupleSketchedSets.getEstimateOfBoverA((org.apache.datasketches.tuple.Sketch)skA, (org.apache.datasketches.tuple.Sketch)skB);
        double lb = BoundsOnRatiosInTupleSketchedSets.getLowerBoundForBoverA((org.apache.datasketches.tuple.Sketch)skA, (org.apache.datasketches.tuple.Sketch)skB);
        double ub = BoundsOnRatiosInTupleSketchedSets.getUpperBoundForBoverA((org.apache.datasketches.tuple.Sketch)skA, (org.apache.datasketches.tuple.Sketch)skB);
        Assert.assertTrue((ub > est ? 1 : 0) != 0);
        Assert.assertTrue((est > lb ? 1 : 0) != 0);
        Assert.assertEquals((double)est, (double)0.5, (double)0.03);
        BoundsOnRatiosInTupleSketchedSetsTest.println("ub : " + ub);
        BoundsOnRatiosInTupleSketchedSetsTest.println("est: " + est);
        BoundsOnRatiosInTupleSketchedSetsTest.println("lb : " + lb);
        skA.reset();
        est = BoundsOnRatiosInTupleSketchedSets.getEstimateOfBoverA((org.apache.datasketches.tuple.Sketch)skA, (org.apache.datasketches.tuple.Sketch)skB);
        lb = BoundsOnRatiosInTupleSketchedSets.getLowerBoundForBoverA((org.apache.datasketches.tuple.Sketch)skA, (org.apache.datasketches.tuple.Sketch)skB);
        ub = BoundsOnRatiosInTupleSketchedSets.getUpperBoundForBoverA((org.apache.datasketches.tuple.Sketch)skA, (org.apache.datasketches.tuple.Sketch)skB);
        BoundsOnRatiosInTupleSketchedSetsTest.println("ub : " + ub);
        BoundsOnRatiosInTupleSketchedSetsTest.println("est: " + est);
        BoundsOnRatiosInTupleSketchedSetsTest.println("lb : " + lb);
        skC.reset();
        est = BoundsOnRatiosInTupleSketchedSets.getEstimateOfBoverA((org.apache.datasketches.tuple.Sketch)skA, (org.apache.datasketches.tuple.Sketch)skC);
        lb = BoundsOnRatiosInTupleSketchedSets.getLowerBoundForBoverA((org.apache.datasketches.tuple.Sketch)skA, (org.apache.datasketches.tuple.Sketch)skC);
        ub = BoundsOnRatiosInTupleSketchedSets.getUpperBoundForBoverA((org.apache.datasketches.tuple.Sketch)skA, (org.apache.datasketches.tuple.Sketch)skC);
        BoundsOnRatiosInTupleSketchedSetsTest.println("ub : " + ub);
        BoundsOnRatiosInTupleSketchedSetsTest.println("est: " + est);
        BoundsOnRatiosInTupleSketchedSetsTest.println("lb : " + lb);
    }

    @Test
    public void checkNormalReturns2() {
        int i;
        UpdatableSketch skA = this.tupleBldr.build();
        UpdateSketch skC = this.thetaBldr.build();
        int uA = 10000;
        int uC = 100000;
        for (i = 0; i < 10000; ++i) {
            skA.update((long)i, (Object)this.constSummary);
        }
        for (i = 0; i < 100000; ++i) {
            skC.update((long)(i + 5000));
        }
        Intersection inter = new Intersection((SummarySetOperations)this.dsso);
        inter.intersect((org.apache.datasketches.tuple.Sketch)skA);
        inter.intersect((Sketch)skC, (Summary)this.factory.newSummary());
        CompactSketch skB = inter.getResult();
        double est = BoundsOnRatiosInTupleSketchedSets.getEstimateOfBoverA((org.apache.datasketches.tuple.Sketch)skA, (org.apache.datasketches.tuple.Sketch)skB);
        double lb = BoundsOnRatiosInTupleSketchedSets.getLowerBoundForBoverA((org.apache.datasketches.tuple.Sketch)skA, (org.apache.datasketches.tuple.Sketch)skB);
        double ub = BoundsOnRatiosInTupleSketchedSets.getUpperBoundForBoverA((org.apache.datasketches.tuple.Sketch)skA, (org.apache.datasketches.tuple.Sketch)skB);
        Assert.assertTrue((ub > est ? 1 : 0) != 0);
        Assert.assertTrue((est > lb ? 1 : 0) != 0);
        Assert.assertEquals((double)est, (double)0.5, (double)0.03);
        BoundsOnRatiosInTupleSketchedSetsTest.println("ub : " + ub);
        BoundsOnRatiosInTupleSketchedSetsTest.println("est: " + est);
        BoundsOnRatiosInTupleSketchedSetsTest.println("lb : " + lb);
        skA.reset();
        est = BoundsOnRatiosInTupleSketchedSets.getEstimateOfBoverA((org.apache.datasketches.tuple.Sketch)skA, (org.apache.datasketches.tuple.Sketch)skB);
        lb = BoundsOnRatiosInTupleSketchedSets.getLowerBoundForBoverA((org.apache.datasketches.tuple.Sketch)skA, (org.apache.datasketches.tuple.Sketch)skB);
        ub = BoundsOnRatiosInTupleSketchedSets.getUpperBoundForBoverA((org.apache.datasketches.tuple.Sketch)skA, (org.apache.datasketches.tuple.Sketch)skB);
        BoundsOnRatiosInTupleSketchedSetsTest.println("ub : " + ub);
        BoundsOnRatiosInTupleSketchedSetsTest.println("est: " + est);
        BoundsOnRatiosInTupleSketchedSetsTest.println("lb : " + lb);
        skC.reset();
        est = BoundsOnRatiosInTupleSketchedSets.getEstimateOfBoverA((org.apache.datasketches.tuple.Sketch)skA, (Sketch)skC);
        lb = BoundsOnRatiosInTupleSketchedSets.getLowerBoundForBoverA((org.apache.datasketches.tuple.Sketch)skA, (Sketch)skC);
        ub = BoundsOnRatiosInTupleSketchedSets.getUpperBoundForBoverA((org.apache.datasketches.tuple.Sketch)skA, (Sketch)skC);
        BoundsOnRatiosInTupleSketchedSetsTest.println("ub : " + ub);
        BoundsOnRatiosInTupleSketchedSetsTest.println("est: " + est);
        BoundsOnRatiosInTupleSketchedSetsTest.println("lb : " + lb);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkAbnormalReturns1() {
        int i;
        UpdatableSketch skA = this.tupleBldr.build();
        UpdatableSketch skC = this.tupleBldr.build();
        int uA = 100000;
        int uC = 10000;
        for (i = 0; i < 100000; ++i) {
            skA.update((long)i, (Object)this.constSummary);
        }
        for (i = 0; i < 10000; ++i) {
            skC.update((long)(i + 50000), (Object)this.constSummary);
        }
        BoundsOnRatiosInTupleSketchedSets.getEstimateOfBoverA((org.apache.datasketches.tuple.Sketch)skA, (org.apache.datasketches.tuple.Sketch)skC);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkAbnormalReturns2() {
        int i;
        UpdatableSketch skA = this.tupleBldr.build();
        UpdateSketch skC = this.thetaBldr.build();
        int uA = 100000;
        int uC = 10000;
        for (i = 0; i < 100000; ++i) {
            skA.update((long)i, (Object)this.constSummary);
        }
        for (i = 0; i < 10000; ++i) {
            skC.update((long)(i + 50000));
        }
        BoundsOnRatiosInTupleSketchedSets.getEstimateOfBoverA((org.apache.datasketches.tuple.Sketch)skA, (Sketch)skC);
    }

    @Test
    public void printlnTest() {
        BoundsOnRatiosInTupleSketchedSetsTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

