/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator.routines;

import java.text.DateFormat;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.lang3.time.TimeZones;
import org.apache.commons.validator.routines.AbstractCalendarValidator;
import org.apache.commons.validator.routines.AbstractCalendarValidatorTest;
import org.apache.commons.validator.routines.CalendarValidator;
import org.apache.commons.validator.util.TestTimeZones;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junitpioneer.jupiter.DefaultLocale;
import org.junitpioneer.jupiter.DefaultTimeZone;

class CalendarValidatorTest
extends AbstractCalendarValidatorTest {
    private static final int DATE_2005_11_23 = 20051123;
    private static final int TIME_12_03_45 = 120345;
    private CalendarValidator calValidator;

    CalendarValidatorTest() {
    }

    @BeforeEach
    protected void setUp() {
        this.calValidator = new CalendarValidator();
        this.validator = this.calValidator;
    }

    @Test
    void testAdjustToTimeZone() {
        Calendar calEST = CalendarValidatorTest.createCalendar(TestTimeZones.EST, 20051123, 120345);
        Date dateEST = calEST.getTime();
        Calendar calGMT = CalendarValidatorTest.createCalendar(TimeZones.GMT, 20051123, 120345);
        Date dateGMT = calGMT.getTime();
        Calendar calCET = CalendarValidatorTest.createCalendar(TestTimeZones.EET, 20051123, 120345);
        Date dateCET = calCET.getTime();
        Assertions.assertNotEquals((long)dateGMT.getTime(), (long)dateCET.getTime(), (String)"Check GMT != CET");
        Assertions.assertNotEquals((long)dateGMT.getTime(), (long)dateEST.getTime(), (String)"Check GMT != EST");
        Assertions.assertNotEquals((long)dateCET.getTime(), (long)dateEST.getTime(), (String)"Check CET != EST");
        CalendarValidator.adjustToTimeZone((Calendar)calEST, (TimeZone)TimeZones.GMT);
        Assertions.assertEquals((Object)dateGMT, (Object)calEST.getTime(), (String)"EST to GMT");
        Assertions.assertNotSame((Object)dateEST, (Object)calEST.getTime(), (String)"Check EST = GMT");
        CalendarValidator.adjustToTimeZone((Calendar)calEST, (TimeZone)TestTimeZones.EST);
        Assertions.assertEquals((Object)dateEST, (Object)calEST.getTime(), (String)"back to EST");
        Assertions.assertNotSame((Object)dateGMT, (Object)calEST.getTime(), (String)"Check EST != GMT");
        CalendarValidator.adjustToTimeZone((Calendar)calCET, (TimeZone)TimeZones.GMT);
        Assertions.assertEquals((Object)dateGMT, (Object)calCET.getTime(), (String)"CET to GMT");
        Assertions.assertNotSame((Object)dateCET, (Object)calCET.getTime(), (String)"Check CET = GMT");
        CalendarValidator.adjustToTimeZone((Calendar)calCET, (TimeZone)TestTimeZones.EET);
        Assertions.assertEquals((Object)dateCET, (Object)calCET.getTime(), (String)"back to CET");
        Assertions.assertNotSame((Object)dateGMT, (Object)calCET.getTime(), (String)"Check CET != GMT");
        Calendar calUTC = CalendarValidatorTest.createCalendar(TestTimeZones.UTC, 20051123, 120345);
        Assertions.assertTrue((boolean)TestTimeZones.UTC.hasSameRules(TimeZones.GMT), (String)"SAME: UTC = GMT");
        Assertions.assertEquals((Object)calUTC.getTime(), (Object)calGMT.getTime(), (String)"SAME: Check time (A)");
        Assertions.assertNotEquals((Object)TimeZones.GMT, (Object)calUTC.getTimeZone(), (String)"SAME: Check GMT(A)");
        Assertions.assertEquals((Object)TestTimeZones.UTC, (Object)calUTC.getTimeZone(), (String)"SAME: Check UTC(A)");
        CalendarValidator.adjustToTimeZone((Calendar)calUTC, (TimeZone)TimeZones.GMT);
        Assertions.assertEquals((Object)calUTC.getTime(), (Object)calGMT.getTime(), (String)"SAME: Check time (B)");
        Assertions.assertEquals((Object)TimeZones.GMT, (Object)calUTC.getTimeZone(), (String)"SAME: Check GMT(B)");
        Assertions.assertNotEquals((Object)TestTimeZones.UTC, (Object)calUTC.getTimeZone(), (String)"SAME: Check UTC(B)");
    }

    @Test
    @DefaultLocale(country="US", language="en")
    void testCalendarValidatorMethods() {
        Locale locale = Locale.GERMAN;
        String pattern = "yyyy-MM-dd";
        String patternVal = "2005-12-31";
        String germanPattern = "dd MMM yyyy";
        SimpleDateFormat df = new SimpleDateFormat("dd MMM yyyy", locale);
        Calendar cal = Calendar.getInstance(Locale.US);
        cal.set(2005, 11, 31);
        String germanVal = df.format(cal.getTime());
        String localeVal = "31.12.2005";
        String defaultVal = "12/31/05";
        String xxxx = "XXXX";
        Date expected = CalendarValidatorTest.createCalendar(null, 20051231, 0).getTime();
        Assertions.assertEquals((Object)expected, (Object)CalendarValidator.getInstance().validate("12/31/05").getTime(), (String)"validate(A) default");
        Assertions.assertEquals((Object)expected, (Object)CalendarValidator.getInstance().validate("31.12.2005", locale).getTime(), (String)"validate(A) locale ");
        Assertions.assertEquals((Object)expected, (Object)CalendarValidator.getInstance().validate("2005-12-31", "yyyy-MM-dd").getTime(), (String)"validate(A) pattern");
        Assertions.assertEquals((Object)expected, (Object)CalendarValidator.getInstance().validate(germanVal, "dd MMM yyyy", Locale.GERMAN).getTime(), (String)"validate(A) both");
        Assertions.assertTrue((boolean)CalendarValidator.getInstance().isValid("12/31/05"), (String)"isValid(A) default");
        Assertions.assertTrue((boolean)CalendarValidator.getInstance().isValid("31.12.2005", locale), (String)"isValid(A) locale ");
        Assertions.assertTrue((boolean)CalendarValidator.getInstance().isValid("2005-12-31", "yyyy-MM-dd"), (String)"isValid(A) pattern");
        Assertions.assertTrue((boolean)CalendarValidator.getInstance().isValid(germanVal, "dd MMM yyyy", Locale.GERMAN), (String)"isValid(A) both");
        Assertions.assertNull((Object)CalendarValidator.getInstance().validate("XXXX"), (String)"validate(B) default");
        Assertions.assertNull((Object)CalendarValidator.getInstance().validate("XXXX", locale), (String)"validate(B) locale ");
        Assertions.assertNull((Object)CalendarValidator.getInstance().validate("XXXX", "yyyy-MM-dd"), (String)"validate(B) pattern");
        Assertions.assertNull((Object)CalendarValidator.getInstance().validate("31 Dec 2005", "dd MMM yyyy", Locale.GERMAN), (String)"validate(B) both");
        Assertions.assertFalse((boolean)CalendarValidator.getInstance().isValid("XXXX"), (String)"isValid(B) default");
        Assertions.assertFalse((boolean)CalendarValidator.getInstance().isValid("XXXX", locale), (String)"isValid(B) locale ");
        Assertions.assertFalse((boolean)CalendarValidator.getInstance().isValid("XXXX", "yyyy-MM-dd"), (String)"isValid(B) pattern");
        Assertions.assertFalse((boolean)CalendarValidator.getInstance().isValid("31 Dec 2005", "dd MMM yyyy", Locale.GERMAN), (String)"isValid(B) both");
        TimeZone zone = TimeZone.getDefault().getRawOffset() == TestTimeZones.EET.getRawOffset() ? TestTimeZones.EST : TestTimeZones.EET;
        Date expectedZone = CalendarValidatorTest.createCalendar(zone, 20051231, 0).getTime();
        Assertions.assertNotEquals((long)expected.getTime(), (long)expectedZone.getTime(), (String)"default/EET same ");
        Assertions.assertEquals((Object)expectedZone, (Object)CalendarValidator.getInstance().validate("12/31/05", zone).getTime(), (String)"validate(C) default");
        Assertions.assertEquals((Object)expectedZone, (Object)CalendarValidator.getInstance().validate("31.12.2005", locale, zone).getTime(), (String)"validate(C) locale ");
        Assertions.assertEquals((Object)expectedZone, (Object)CalendarValidator.getInstance().validate("2005-12-31", "yyyy-MM-dd", zone).getTime(), (String)"validate(C) pattern");
        Assertions.assertEquals((Object)expectedZone, (Object)CalendarValidator.getInstance().validate(germanVal, "dd MMM yyyy", Locale.GERMAN, zone).getTime(), (String)"validate(C) both");
    }

    @Test
    void testCompare() {
        int sameTime = 124522;
        int testDate = 20050823;
        Calendar diffHour = CalendarValidatorTest.createCalendar(TimeZones.GMT, 20050823, 115922);
        Calendar diffMin = CalendarValidatorTest.createCalendar(TimeZones.GMT, 20050823, 124422);
        Calendar diffSec = CalendarValidatorTest.createCalendar(TimeZones.GMT, 20050823, 124521);
        Calendar value = CalendarValidatorTest.createCalendar(TimeZones.GMT, 20050823, 124522);
        Calendar cal20050824 = CalendarValidatorTest.createCalendar(TimeZones.GMT, 20050824, 124522);
        Calendar cal20050822 = CalendarValidatorTest.createCalendar(TimeZones.GMT, 20050822, 124522);
        Calendar cal20050830 = CalendarValidatorTest.createCalendar(TimeZones.GMT, 20050830, 124522);
        Calendar cal20050816 = CalendarValidatorTest.createCalendar(TimeZones.GMT, 20050816, 124522);
        Calendar cal20050901 = CalendarValidatorTest.createCalendar(TimeZones.GMT, 20050901, 124522);
        Calendar cal20050801 = CalendarValidatorTest.createCalendar(TimeZones.GMT, 20050801, 124522);
        Calendar cal20050731 = CalendarValidatorTest.createCalendar(TimeZones.GMT, 20050731, 124522);
        Calendar cal20051101 = CalendarValidatorTest.createCalendar(TimeZones.GMT, 20051101, 124522);
        Calendar cal20051001 = CalendarValidatorTest.createCalendar(TimeZones.GMT, 20051001, 124522);
        Calendar cal20050701 = CalendarValidatorTest.createCalendar(TimeZones.GMT, 20050701, 124522);
        Calendar cal20050630 = CalendarValidatorTest.createCalendar(TimeZones.GMT, 20050630, 124522);
        Calendar cal20060101 = CalendarValidatorTest.createCalendar(TimeZones.GMT, 20060101, 124522);
        Calendar cal20050101 = CalendarValidatorTest.createCalendar(TimeZones.GMT, 20050101, 124522);
        Calendar cal20041231 = CalendarValidatorTest.createCalendar(TimeZones.GMT, 20041231, 124522);
        Assertions.assertEquals((int)1, (int)this.calValidator.compare(value, diffHour, 11), (String)"hour GT");
        Assertions.assertEquals((int)0, (int)this.calValidator.compare(value, diffMin, 11), (String)"hour EQ");
        Assertions.assertEquals((int)1, (int)this.calValidator.compare(value, diffMin, 12), (String)"mins GT");
        Assertions.assertEquals((int)0, (int)this.calValidator.compare(value, diffSec, 12), (String)"mins EQ");
        Assertions.assertEquals((int)1, (int)this.calValidator.compare(value, diffSec, 13), (String)"secs GT");
        Assertions.assertEquals((int)-1, (int)this.calValidator.compareDates(value, cal20050824), (String)"date LT");
        Assertions.assertEquals((int)0, (int)this.calValidator.compareDates(value, diffHour), (String)"date EQ");
        Assertions.assertEquals((int)0, (int)this.calValidator.compare(value, diffHour, 6), (String)"date(B)");
        Assertions.assertEquals((int)1, (int)this.calValidator.compareDates(value, cal20050822), (String)"date GT");
        Assertions.assertEquals((int)-1, (int)this.calValidator.compareWeeks(value, cal20050830), (String)"week LT");
        Assertions.assertEquals((int)0, (int)this.calValidator.compareWeeks(value, cal20050824), (String)"week =1");
        Assertions.assertEquals((int)0, (int)this.calValidator.compareWeeks(value, cal20050822), (String)"week =2");
        Assertions.assertEquals((int)0, (int)this.calValidator.compare(value, cal20050822, 4), (String)"week =3");
        Assertions.assertEquals((int)0, (int)this.calValidator.compareWeeks(value, cal20050822), (String)"week =4");
        Assertions.assertEquals((int)1, (int)this.calValidator.compareWeeks(value, cal20050816), (String)"week GT");
        Assertions.assertEquals((int)-1, (int)this.calValidator.compareMonths(value, cal20050901), (String)"mnth LT");
        Assertions.assertEquals((int)0, (int)this.calValidator.compareMonths(value, cal20050830), (String)"mnth =1");
        Assertions.assertEquals((int)0, (int)this.calValidator.compareMonths(value, cal20050801), (String)"mnth =2");
        Assertions.assertEquals((int)0, (int)this.calValidator.compareMonths(value, cal20050816), (String)"mnth =3");
        Assertions.assertEquals((int)1, (int)this.calValidator.compareMonths(value, cal20050731), (String)"mnth GT");
        Assertions.assertEquals((int)-1, (int)this.calValidator.compareQuarters(value, cal20051101), (String)"qtrA <1");
        Assertions.assertEquals((int)-1, (int)this.calValidator.compareQuarters(value, cal20051001), (String)"qtrA <2");
        Assertions.assertEquals((int)0, (int)this.calValidator.compareQuarters(value, cal20050901), (String)"qtrA =1");
        Assertions.assertEquals((int)0, (int)this.calValidator.compareQuarters(value, cal20050701), (String)"qtrA =2");
        Assertions.assertEquals((int)0, (int)this.calValidator.compareQuarters(value, cal20050731), (String)"qtrA =3");
        Assertions.assertEquals((int)1, (int)this.calValidator.compareQuarters(value, cal20050630), (String)"qtrA GT");
        Assertions.assertEquals((int)-1, (int)this.calValidator.compareQuarters(value, cal20051101, 2), (String)"qtrB LT");
        Assertions.assertEquals((int)0, (int)this.calValidator.compareQuarters(value, cal20051001, 2), (String)"qtrB =1");
        Assertions.assertEquals((int)0, (int)this.calValidator.compareQuarters(value, cal20050901, 2), (String)"qtrB =2");
        Assertions.assertEquals((int)1, (int)this.calValidator.compareQuarters(value, cal20050701, 2), (String)"qtrB =3");
        Assertions.assertEquals((int)1, (int)this.calValidator.compareQuarters(value, cal20050731, 2), (String)"qtrB =4");
        Assertions.assertEquals((int)1, (int)this.calValidator.compareQuarters(value, cal20050630, 2), (String)"qtrB GT");
        Assertions.assertEquals((int)-1, (int)this.calValidator.compareYears(value, cal20060101), (String)"year LT");
        Assertions.assertEquals((int)0, (int)this.calValidator.compareYears(value, cal20050101), (String)"year EQ");
        Assertions.assertEquals((int)1, (int)this.calValidator.compareYears(value, cal20041231), (String)"year GT");
        Exception e = (Exception)Assertions.assertThrows(IllegalArgumentException.class, () -> this.calValidator.compare(value, value, -1), (String)"Invalid Compare field");
        Assertions.assertEquals((Object)"Invalid field: -1", (Object)e.getMessage(), (String)"check message");
    }

    @Test
    @DefaultLocale(country="UK", language="en")
    void testDateTimeStyle() {
        DateFormat df = DateFormat.getDateTimeInstance(3, 3);
        Calendar cal = Calendar.getInstance();
        cal.set(2005, 11, 31, 14, 23);
        String val = df.format(cal.getTime());
        DateFormat usdf = DateFormat.getDateTimeInstance(3, 3, Locale.US);
        Calendar uscal = Calendar.getInstance(Locale.US);
        uscal.set(2005, 11, 31, 14, 23);
        String usval = usdf.format(uscal.getTime());
        AbstractCalendarValidator dateTimeValidator = new AbstractCalendarValidator(true, 3, 3){
            private static final long serialVersionUID = 1L;

            protected Object processParsedValue(Object value, Format formatter) {
                return value;
            }
        };
        Assertions.assertTrue((boolean)dateTimeValidator.isValid(val), (String)"validate(A) default");
        Assertions.assertTrue((boolean)dateTimeValidator.isValid(usval, Locale.US), (String)"validate(A) locale ");
    }

    @Override
    @Test
    @DefaultLocale(country="UK", language="en")
    @DefaultTimeZone(value="GMT")
    void testFormat() {
        Calendar cal20051231 = CalendarValidatorTest.createCalendar(TimeZones.GMT, 20051231, 11500);
        DateFormat df = DateFormat.getDateInstance(3);
        String val = df.format(cal20051231.getTime());
        DateFormat dfus = DateFormat.getDateInstance(3, Locale.US);
        String usval = dfus.format(cal20051231.getTime());
        String germanPattern = "dd MMM yyyy";
        SimpleDateFormat dedf = new SimpleDateFormat("dd MMM yyyy", Locale.GERMAN);
        String deval = dedf.format(cal20051231.getTime());
        Assertions.assertNull((Object)this.calValidator.format(null), (String)"null");
        Assertions.assertEquals((Object)val, (Object)this.calValidator.format((Object)cal20051231), (String)"default");
        Assertions.assertEquals((Object)usval, (Object)this.calValidator.format((Object)cal20051231, Locale.US), (String)"locale");
        Assertions.assertEquals((Object)"2005-12-31 01:15", (Object)this.calValidator.format((Object)cal20051231, "yyyy-MM-dd HH:mm"), (String)"patternA");
        Assertions.assertEquals((Object)"2005-12-31 GMT", (Object)this.calValidator.format((Object)cal20051231, "yyyy-MM-dd z"), (String)"patternB");
        Assertions.assertEquals((Object)deval, (Object)this.calValidator.format((Object)cal20051231, "dd MMM yyyy", Locale.GERMAN), (String)"both");
        DateFormat dfest = DateFormat.getDateInstance(3);
        dfest.setTimeZone(TestTimeZones.EST);
        String valest = dfest.format(cal20051231.getTime());
        DateFormat dfusest = DateFormat.getDateInstance(3, Locale.US);
        dfusest.setTimeZone(TestTimeZones.EST);
        String valusest = dfusest.format(cal20051231.getTime());
        SimpleDateFormat dedfest = new SimpleDateFormat("dd MMM yyyy", Locale.GERMAN);
        dedfest.setTimeZone(TestTimeZones.EST);
        String devalest = dedfest.format(cal20051231.getTime());
        Assertions.assertEquals((Object)valest, (Object)this.calValidator.format((Object)cal20051231, TestTimeZones.EST), (String)"EST default");
        Assertions.assertEquals((Object)valusest, (Object)this.calValidator.format((Object)cal20051231, Locale.US, TestTimeZones.EST), (String)"EST locale");
        String patternA = "yyyy-MM-dd HH:mm";
        SimpleDateFormat dfA = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        dfA.setTimeZone(TestTimeZones.EST);
        String valA = dfA.format(cal20051231.getTime());
        Assertions.assertEquals((Object)valA, (Object)this.calValidator.format((Object)cal20051231, "yyyy-MM-dd HH:mm", TestTimeZones.EST), (String)"EST patternA");
        String patternB = "yyyy-MM-dd z";
        SimpleDateFormat dfB = new SimpleDateFormat("yyyy-MM-dd z");
        dfB.setTimeZone(TestTimeZones.EST);
        String valB = dfB.format(cal20051231.getTime());
        Assertions.assertEquals((Object)valB, (Object)this.calValidator.format((Object)cal20051231, "yyyy-MM-dd z", TestTimeZones.EST), (String)"EST patternB");
        Assertions.assertEquals((Object)devalest, (Object)this.calValidator.format((Object)cal20051231, "dd MMM yyyy", Locale.GERMAN, TestTimeZones.EST), (String)"EST both");
    }
}

