/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.statistics.descriptive;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import org.apache.commons.statistics.descriptive.IntMath;
import org.apache.commons.statistics.descriptive.UInt96;

final class UInt128 {
    private static final long MASK32 = 0xFFFFFFFFL;
    private int d;
    private int c;
    private long ab;

    private UInt128() {
    }

    private UInt128(long hi, int mid, int lo) {
        this.d = lo;
        this.c = mid;
        this.ab = hi;
    }

    UInt128(long hi, long lo) {
        this.d = (int)lo;
        this.c = (int)(lo >>> 32);
        this.ab = hi;
    }

    static UInt128 create() {
        return new UInt128();
    }

    static UInt128 of(UInt96 x) {
        int lo = x.lo32();
        long hi = x.hi64();
        UInt128 y = new UInt128();
        y.d = lo;
        y.c = (int)hi;
        y.ab = hi >>> 32;
        return y;
    }

    void addPositive(long x) {
        long s = x + ((long)this.d & 0xFFFFFFFFL);
        this.d = (int)s;
        s = (s >>> 32) + ((long)this.c & 0xFFFFFFFFL);
        this.c = (int)s;
        this.ab += s >>> 32;
    }

    void add(UInt128 x) {
        int dd = x.d;
        int cc = x.c;
        long aabb = x.ab;
        long s = ((long)dd & 0xFFFFFFFFL) + ((long)this.d & 0xFFFFFFFFL);
        this.d = (int)s;
        s = (s >>> 32) + ((long)cc & 0xFFFFFFFFL) + ((long)this.c & 0xFFFFFFFFL);
        this.c = (int)s;
        this.ab += (s >>> 32) + aabb;
    }

    UInt128 unsignedMultiply(int x) {
        long xx = (long)x & 0xFFFFFFFFL;
        long product = xx * ((long)this.d & 0xFFFFFFFFL);
        int dd = (int)product;
        product = (product >>> 32) + xx * ((long)this.c & 0xFFFFFFFFL);
        int cc = (int)product;
        long aabb = (product >>> 32) + xx * this.ab;
        return new UInt128(aabb, cc, dd);
    }

    UInt128 subtract(UInt128 x) {
        long diff = ((long)this.d & 0xFFFFFFFFL) - ((long)x.d & 0xFFFFFFFFL);
        int dd = (int)diff;
        diff = (diff >> 32) + ((long)this.c & 0xFFFFFFFFL) - ((long)x.c & 0xFFFFFFFFL);
        int cc = (int)diff;
        long aabb = (diff >> 32) + this.ab - x.ab;
        return new UInt128(aabb, cc, dd);
    }

    BigInteger toBigInteger() {
        if (this.ab != 0L || this.c < 0) {
            return new BigInteger(1, ByteBuffer.allocate(16).putLong(this.ab).putInt(this.c).putInt(this.d).array());
        }
        return BigInteger.valueOf(this.lo64());
    }

    double toDouble() {
        return IntMath.uint128ToDouble(this.hi64(), this.lo64());
    }

    int toIntExact() {
        return Math.toIntExact(this.toLongExact());
    }

    long toLongExact() {
        if (this.ab != 0L || this.c < 0) {
            throw new ArithmeticException("long integer overflow");
        }
        return this.lo64();
    }

    long lo64() {
        return (long)this.d & 0xFFFFFFFFL | ((long)this.c & 0xFFFFFFFFL) << 32;
    }

    int lo32() {
        return this.d;
    }

    int mid32() {
        return this.c;
    }

    long hi64() {
        return this.ab;
    }
}

