/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.digest;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.codec.digest.Crypt;
import org.apache.commons.codec.digest.Sha2Crypt;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class Sha256CryptTest {
    Sha256CryptTest() {
    }

    @Test
    void testSha256CryptBytes() {
        Assertions.assertEquals((Object)"$5$foo$Fq9CX624QIfnCAmlGiPKLlAasdacKCRxZztPoeo7o0B", (Object)Crypt.crypt((byte[])new byte[0], (String)"$5$foo"));
        Assertions.assertEquals((Object)"$5$./$iH66LwY5sTDTdHeOxq5nvNDVAxuoCcyH/y6Ptte82P8", (Object)Crypt.crypt((String)"t\u00e4st", (String)"$5$./$"));
        Assertions.assertEquals((Object)"$5$./$qx5gFfCzjuWUOvsDDy.5Nor3UULPIqLVBZhgGNS0c14", (Object)Crypt.crypt((byte[])"t\u00e4st".getBytes(StandardCharsets.ISO_8859_1), (String)"$5$./$"));
    }

    @Test
    void testSha256CryptExplicitCall() {
        Assertions.assertTrue((boolean)Sha2Crypt.sha256Crypt((byte[])"secret".getBytes()).matches("^\\$5\\$[a-zA-Z0-9./]{0,16}\\$.{1,}$"));
        Assertions.assertTrue((boolean)Sha2Crypt.sha256Crypt((byte[])"secret".getBytes(), null).matches("^\\$5\\$[a-zA-Z0-9./]{0,16}\\$.{1,}$"));
    }

    @Test
    void testSha256CryptNullData() {
        Assertions.assertThrows(NullPointerException.class, () -> Sha2Crypt.sha256Crypt((byte[])null));
    }

    @Test
    void testSha256CryptStrings() {
        Assertions.assertEquals((Object)"$5$foo$Fq9CX624QIfnCAmlGiPKLlAasdacKCRxZztPoeo7o0B", (Object)Crypt.crypt((String)"", (String)"$5$foo"));
        Assertions.assertEquals((Object)"$5$45678$LulJuUIJIn.1uU.KPV9x92umMYFopzVDD.o2ZqA1i2/", (Object)Crypt.crypt((String)"secret", (String)"$5$45678"));
        Assertions.assertEquals((Object)"$5$45678$LulJuUIJIn.1uU.KPV9x92umMYFopzVDD.o2ZqA1i2/", (Object)Crypt.crypt((String)"secret", (String)"$5$45678$012"));
        Assertions.assertEquals((Object)"$5$45678$LulJuUIJIn.1uU.KPV9x92umMYFopzVDD.o2ZqA1i2/", (Object)Crypt.crypt((String)"secret", (String)"$5$45678$012$456"));
        Assertions.assertEquals((Object)"$5$1234567890123456$GUiFKBSTUAGvcK772ulTDPltkTOLtFvPOmp9o.9FNPB", (Object)Crypt.crypt((String)"secret", (String)"$5$1234567890123456"));
        Assertions.assertEquals((Object)"$5$1234567890123456$GUiFKBSTUAGvcK772ulTDPltkTOLtFvPOmp9o.9FNPB", (Object)Crypt.crypt((String)"secret", (String)"$5$1234567890123456789"));
    }

    @Test
    void testSha256CryptWithEmptySalt() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> Sha2Crypt.sha256Crypt((byte[])"secret".getBytes(), (String)""));
    }

    @Test
    void testSha256LargestThanBlocksize() {
        byte[] buffer = new byte[200];
        Arrays.fill(buffer, 0, 200, (byte)65);
        Assertions.assertEquals((Object)"$5$abc$HbF3RRc15OwNKB/RZZ5F.1I6zsLcKXHQoSdB9Owx/Q8", (Object)Sha2Crypt.sha256Crypt((byte[])buffer, (String)"$5$abc"));
        Assertions.assertArrayEquals((byte[])new byte[buffer.length], (byte[])buffer);
    }

    @Test
    void testSha2CryptRounds() {
        Assertions.assertEquals((Object)"$5$rounds=1000$abcd$b8MCU4GEeZIekOy5ahQ8EWfT330hvYGVeDYkBxXBva.", (Object)Sha2Crypt.sha256Crypt((byte[])"secret".getBytes(StandardCharsets.UTF_8), (String)"$5$rounds=50$abcd$"));
        Assertions.assertEquals((Object)"$5$rounds=1001$abcd$SQsJZs7KXKdd2DtklI3TY3tkD7UYA99RD0FBLm4Sk48", (Object)Sha2Crypt.sha256Crypt((byte[])"secret".getBytes(StandardCharsets.UTF_8), (String)"$5$rounds=1001$abcd$"));
        Assertions.assertEquals((Object)"$5$rounds=9999$abcd$Rh/8ngVh9oyuS6lL3.fsq.9xbvXJsfyKWxSjO2mPIa7", (Object)Sha2Crypt.sha256Crypt((byte[])"secret".getBytes(StandardCharsets.UTF_8), (String)"$5$rounds=9999$abcd"));
    }

    @Test
    void testSha2CryptRoundsThreadLocalRandom() {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        Assertions.assertEquals((Object)"$5$rounds=1000$abcd$b8MCU4GEeZIekOy5ahQ8EWfT330hvYGVeDYkBxXBva.", (Object)Sha2Crypt.sha256Crypt((byte[])"secret".getBytes(StandardCharsets.UTF_8), (String)"$5$rounds=50$abcd$", (Random)random));
        Assertions.assertEquals((Object)"$5$rounds=1001$abcd$SQsJZs7KXKdd2DtklI3TY3tkD7UYA99RD0FBLm4Sk48", (Object)Sha2Crypt.sha256Crypt((byte[])"secret".getBytes(StandardCharsets.UTF_8), (String)"$5$rounds=1001$abcd$", (Random)random));
        Assertions.assertEquals((Object)"$5$rounds=9999$abcd$Rh/8ngVh9oyuS6lL3.fsq.9xbvXJsfyKWxSjO2mPIa7", (Object)Sha2Crypt.sha256Crypt((byte[])"secret".getBytes(StandardCharsets.UTF_8), (String)"$5$rounds=9999$abcd", (Random)random));
    }

    @Test
    void testZeroOutInput() {
        byte[] buffer = new byte[200];
        Arrays.fill(buffer, (byte)65);
        Sha2Crypt.sha256Crypt((byte[])buffer);
        Assertions.assertArrayEquals((byte[])new byte[buffer.length], (byte[])buffer);
    }
}

