/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Locale;
import org.apache.bcel.Const;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.ConstantValue;
import org.apache.bcel.classfile.EmptyVisitor;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.Type;
import org.apache.bcel.util.BCELFactory;

public class BCELifier
extends EmptyVisitor {
    private static final String BASE_PACKAGE = Const.class.getPackage().getName();
    private static final String CONSTANT_PREFIX = Const.class.getSimpleName() + ".";
    private final JavaClass _clazz;
    private final PrintWriter _out;
    private final ConstantPoolGen _cp;

    public BCELifier(JavaClass clazz, OutputStream out) {
        this._clazz = clazz;
        this._out = new PrintWriter(out);
        this._cp = new ConstantPoolGen(this._clazz.getConstantPool());
    }

    public void start() {
        this.visitJavaClass(this._clazz);
        this._out.flush();
    }

    @Override
    public void visitJavaClass(JavaClass clazz) {
        String class_name = clazz.getClassName();
        String super_name = clazz.getSuperclassName();
        String package_name = clazz.getPackageName();
        String inter = Utility.printArray(clazz.getInterfaceNames(), false, true);
        if (!"".equals(package_name)) {
            class_name = class_name.substring(package_name.length() + 1);
            this._out.println("package " + package_name + ";");
            this._out.println();
        }
        this._out.println("import " + BASE_PACKAGE + ".generic.*;");
        this._out.println("import " + BASE_PACKAGE + ".classfile.*;");
        this._out.println("import " + BASE_PACKAGE + ".*;");
        this._out.println("import java.io.*;");
        this._out.println();
        this._out.println("public class " + class_name + "Creator {");
        this._out.println("  private InstructionFactory _factory;");
        this._out.println("  private ConstantPoolGen    _cp;");
        this._out.println("  private ClassGen           _cg;");
        this._out.println();
        this._out.println("  public " + class_name + "Creator() {");
        this._out.println("    _cg = new ClassGen(\"" + ("".equals(package_name) ? class_name : package_name + "." + class_name) + "\", \"" + super_name + "\", \"" + clazz.getSourceFileName() + "\", " + BCELifier.printFlags(clazz.getAccessFlags(), FLAGS.CLASS) + ", new String[] { " + inter + " });");
        this._out.println("    _cg.setMajor(" + clazz.getMajor() + ");");
        this._out.println("    _cg.setMinor(" + clazz.getMinor() + ");");
        this._out.println();
        this._out.println("    _cp = _cg.getConstantPool();");
        this._out.println("    _factory = new InstructionFactory(_cg, _cp);");
        this._out.println("  }");
        this._out.println();
        this.printCreate();
        Field[] fields = clazz.getFields();
        if (fields.length > 0) {
            this._out.println("  private void createFields() {");
            this._out.println("    FieldGen field;");
            for (Field field : fields) {
                field.accept(this);
            }
            this._out.println("  }");
            this._out.println();
        }
        Method[] methods = clazz.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            this._out.println("  private void createMethod_" + i + "() {");
            methods[i].accept(this);
            this._out.println("  }");
            this._out.println();
        }
        this.printMain();
        this._out.println("}");
    }

    private void printCreate() {
        this._out.println("  public void create(OutputStream out) throws IOException {");
        Field[] fields = this._clazz.getFields();
        if (fields.length > 0) {
            this._out.println("    createFields();");
        }
        Method[] methods = this._clazz.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            this._out.println("    createMethod_" + i + "();");
        }
        this._out.println("    _cg.getJavaClass().dump(out);");
        this._out.println("  }");
        this._out.println();
    }

    private void printMain() {
        String class_name = this._clazz.getClassName();
        this._out.println("  public static void main(String[] args) throws Exception {");
        this._out.println("    " + class_name + "Creator creator = new " + class_name + "Creator();");
        this._out.println("    creator.create(new FileOutputStream(\"" + class_name + ".class\"));");
        this._out.println("  }");
    }

    @Override
    public void visitField(Field field) {
        this._out.println();
        this._out.println("    field = new FieldGen(" + BCELifier.printFlags(field.getAccessFlags()) + ", " + BCELifier.printType(field.getSignature()) + ", \"" + field.getName() + "\", _cp);");
        ConstantValue cv = field.getConstantValue();
        if (cv != null) {
            String value = cv.toString();
            this._out.println("    field.setInitValue(" + value + ")");
        }
        this._out.println("    _cg.addField(field.getField());");
    }

    @Override
    public void visitMethod(Method method) {
        MethodGen mg = new MethodGen(method, this._clazz.getClassName(), this._cp);
        this._out.println("    InstructionList il = new InstructionList();");
        this._out.println("    MethodGen method = new MethodGen(" + BCELifier.printFlags(method.getAccessFlags(), FLAGS.METHOD) + ", " + BCELifier.printType(mg.getReturnType()) + ", " + BCELifier.printArgumentTypes(mg.getArgumentTypes()) + ", new String[] { " + Utility.printArray(mg.getArgumentNames(), false, true) + " }, \"" + method.getName() + "\", \"" + this._clazz.getClassName() + "\", il, _cp);");
        this._out.println();
        BCELFactory factory = new BCELFactory(mg, this._out);
        factory.start();
        this._out.println("    method.setMaxStack();");
        this._out.println("    method.setMaxLocals();");
        this._out.println("    _cg.addMethod(method.getMethod());");
        this._out.println("    il.dispose();");
    }

    static String printFlags(int flags) {
        return BCELifier.printFlags(flags, FLAGS.UNKNOWN);
    }

    public static String printFlags(int flags, FLAGS location) {
        if (flags == 0) {
            return "0";
        }
        StringBuilder buf = new StringBuilder();
        int i = 0;
        int pow = 1;
        while (pow <= 32768) {
            if ((flags & pow) != 0) {
                if (pow == 32 && location == FLAGS.CLASS) {
                    buf.append(CONSTANT_PREFIX + "ACC_SUPER | ");
                } else if (pow == 64 && location == FLAGS.METHOD) {
                    buf.append(CONSTANT_PREFIX + "ACC_BRIDGE | ");
                } else if (pow == 128 && location == FLAGS.METHOD) {
                    buf.append(CONSTANT_PREFIX + "ACC_VARARGS | ");
                } else if (i < Const.ACCESS_NAMES_LENGTH) {
                    buf.append(CONSTANT_PREFIX + "ACC_").append(Const.getAccessName(i).toUpperCase(Locale.ENGLISH)).append(" | ");
                } else {
                    buf.append(String.format(CONSTANT_PREFIX + "ACC_BIT %x | ", pow));
                }
            }
            pow <<= 1;
            ++i;
        }
        String str = buf.toString();
        return str.substring(0, str.length() - 3);
    }

    static String printArgumentTypes(Type[] arg_types) {
        if (arg_types.length == 0) {
            return "Type.NO_ARGS";
        }
        StringBuilder args = new StringBuilder();
        for (int i = 0; i < arg_types.length; ++i) {
            args.append(BCELifier.printType(arg_types[i]));
            if (i >= arg_types.length - 1) continue;
            args.append(", ");
        }
        return "new Type[] { " + args.toString() + " }";
    }

    static String printType(Type type) {
        return BCELifier.printType(type.getSignature());
    }

    static String printType(String signature) {
        Type type = Type.getType(signature);
        byte t = type.getType();
        if (t <= 12) {
            return "Type." + Const.getTypeName(t).toUpperCase(Locale.ENGLISH);
        }
        if (type.toString().equals("java.lang.String")) {
            return "Type.STRING";
        }
        if (type.toString().equals("java.lang.Object")) {
            return "Type.OBJECT";
        }
        if (type.toString().equals("java.lang.StringBuffer")) {
            return "Type.STRINGBUFFER";
        }
        if (type instanceof ArrayType) {
            ArrayType at = (ArrayType)type;
            return "new ArrayType(" + BCELifier.printType(at.getBasicType()) + ", " + at.getDimensions() + ")";
        }
        return "new ObjectType(\"" + Utility.signatureToString(signature, false) + "\")";
    }

    public static void main(String[] argv) throws Exception {
        if (argv.length != 1) {
            System.out.println("Usage: BCELifier classname");
            System.out.println("\tThe class must exist on the classpath");
            return;
        }
        JavaClass java_class = BCELifier.getJavaClass(argv[0]);
        BCELifier bcelifier = new BCELifier(java_class, System.out);
        bcelifier.start();
    }

    static JavaClass getJavaClass(String name) throws ClassNotFoundException, IOException {
        JavaClass java_class = Repository.lookupClass(name);
        if (java_class == null) {
            java_class = new ClassParser(name).parse();
        }
        return java_class;
    }

    public static enum FLAGS {
        UNKNOWN,
        CLASS,
        METHOD;

    }
}

