/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.description;

import java.io.InputStream;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.util.UIDGenerator;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.OperationClient;
import org.apache.axis2.client.Options;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.description.OutInAxisOperation;
import org.apache.axis2.description.OutInAxisOperationClient;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.transport.TransportUtils;
import org.apache.axis2.util.Utils;

public class RobustOutOnlyAxisOperation
extends OutInAxisOperation {
    public RobustOutOnlyAxisOperation() {
        QName tmpName = new QName(this.getClass().getName() + "_" + UIDGenerator.generateUID());
        this.setName(tmpName);
        this.setMessageExchangePattern("http://www.w3.org/ns/wsdl/robust-out-only");
    }

    public RobustOutOnlyAxisOperation(QName name) {
        super(name);
        this.setMessageExchangePattern("http://www.w3.org/ns/wsdl/robust-out-only");
    }

    @Override
    public OperationClient createClient(ServiceContext sc, Options options) {
        return new RobustOutOnlyOperationClient(this, sc, options);
    }

    class RobustOutOnlyOperationClient
    extends OutInAxisOperationClient {
        public RobustOutOnlyOperationClient(OutInAxisOperation axisOp, ServiceContext sc, Options options) {
            super(axisOp, sc, options);
        }

        protected void timeOut() throws AxisFault {
        }

        @Override
        protected void handleResponse(MessageContext responseMessageContext) throws AxisFault {
            SOAPEnvelope envelope = responseMessageContext.getEnvelope();
            if (envelope == null) {
                InputStream inStream = (InputStream)responseMessageContext.getProperty("TRANSPORT_IN");
                if (inStream != null && this.checkContentLength(responseMessageContext)) {
                    envelope = TransportUtils.createSOAPMessage(responseMessageContext);
                    responseMessageContext.setEnvelope(envelope);
                }
                responseMessageContext.setEnvelope(envelope);
            }
            if (envelope != null && (envelope.hasFault() || responseMessageContext.isProcessingFault())) {
                AxisEngine.receive(responseMessageContext);
                throw Utils.getInboundFaultFromMessageContext(responseMessageContext);
            }
        }

        private boolean checkContentLength(MessageContext responseMessageContext) {
            Map transportHeaders = (Map)responseMessageContext.getProperty("TRANSPORT_HEADERS");
            if (transportHeaders == null) {
                return true;
            }
            String contentLengthStr = (String)transportHeaders.get("Content-Length");
            if (contentLengthStr == null) {
                return true;
            }
            int contentLength = -1;
            contentLength = Integer.parseInt(contentLengthStr);
            return contentLength > 0;
        }
    }
}

