/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.constant;

import org.apache.camel.Expression;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.Predicate;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.spi.annotations.Language;
import org.apache.camel.support.ExpressionToPredicateAdapter;
import org.apache.camel.support.LanguageSupport;
import org.apache.camel.support.builder.ExpressionBuilder;

@Language(value="constant")
public class ConstantLanguage
extends LanguageSupport {
    public static Expression constant(Object value) {
        return ExpressionBuilder.constantExpression((Object)value);
    }

    public Predicate createPredicate(String expression) {
        return ExpressionToPredicateAdapter.toPredicate((Expression)this.createExpression(expression));
    }

    public Expression createExpression(String expression) {
        if (expression != null && this.isStaticResource(expression)) {
            expression = this.loadResource(expression);
        }
        return ConstantLanguage.constant(expression);
    }

    public Predicate createPredicate(String expression, Object[] properties) {
        Expression exp = this.createExpression(expression, properties);
        return ExpressionToPredicateAdapter.toPredicate((Expression)exp);
    }

    public Expression createExpression(String expression, Object[] properties) {
        Class resultType = (Class)this.property(Class.class, properties, 0, null);
        if (resultType != null) {
            try {
                Object value = this.getCamelContext().getTypeConverter().mandatoryConvertTo(resultType, (Object)expression);
                return ExpressionBuilder.constantExpression((Object)value);
            }
            catch (NoTypeConversionAvailableException e) {
                throw RuntimeCamelException.wrapRuntimeException((Throwable)e);
            }
        }
        return ConstantLanguage.constant(expression);
    }
}

