/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregate;

import org.apache.camel.AggregationStrategy;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.spi.Configurer;
import org.apache.camel.spi.Metadata;

@Metadata(label="bean", description="An AggregationStrategy which just uses the latest exchange which is useful for status messages where old status messages have no real value. Another example is things like market data prices, where old stock prices are not that relevant, only the current price is.", annotations={"interfaceName=org.apache.camel.AggregationStrategy"})
@Configurer(metadataOnly=true)
public class UseLatestAggregationStrategy
implements AggregationStrategy {
    public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
        if (newExchange == null) {
            return oldExchange;
        }
        if (oldExchange == null) {
            return newExchange;
        }
        Exchange answer = null;
        this.propagateException(oldExchange, newExchange);
        if (newExchange.getException() != null) {
            answer = newExchange;
        }
        if (answer == null) {
            answer = this.propagateFailure(oldExchange, newExchange);
        }
        return answer;
    }

    protected void propagateException(Exchange oldExchange, Exchange newExchange) {
        if (oldExchange == null) {
            return;
        }
        if (newExchange.getException() == null) {
            newExchange.setException((Throwable)oldExchange.getException());
            newExchange.setProperty(ExchangePropertyKey.FAILURE_ENDPOINT, oldExchange.getProperty(ExchangePropertyKey.FAILURE_ENDPOINT));
        }
    }

    protected Exchange propagateFailure(Exchange oldExchange, Exchange newExchange) {
        if (oldExchange == null) {
            return newExchange;
        }
        if (oldExchange.isFailed() || oldExchange.isRollbackOnly() || oldExchange.isRollbackOnlyLast() || oldExchange.getExchangeExtension().isErrorHandlerHandledSet() && oldExchange.getExchangeExtension().isErrorHandlerHandled()) {
            return oldExchange;
        }
        return newExchange;
    }

    public String toString() {
        return "UseLatestAggregationStrategy";
    }
}

