/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Traceable;
import org.apache.camel.processor.BaseProcessorSupport;
import org.apache.camel.processor.Throttler;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.RouteIdAware;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractThrottler
extends BaseProcessorSupport
implements Traceable,
IdAware,
RouteIdAware,
Throttler {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractThrottler.class);
    protected static final String DEFAULT_KEY = "CamelThrottlerDefaultKey";
    protected static final String PROPERTY_EXCHANGE_QUEUED_TIMESTAMP = "CamelThrottlerExchangeQueuedTimestamp";
    protected static final String PROPERTY_EXCHANGE_STATE = "CamelThrottlerExchangeState";
    protected final ScheduledExecutorService asyncExecutor;
    protected final boolean shutdownAsyncExecutor;
    protected final CamelContext camelContext;
    protected final Expression correlationExpression;
    protected String id;
    protected String routeId;
    protected boolean rejectExecution;
    protected boolean asyncDelayed;
    protected boolean callerRunsWhenRejected = true;
    protected Expression maxRequestsExpression;

    AbstractThrottler(ScheduledExecutorService asyncExecutor, boolean shutdownAsyncExecutor, CamelContext camelContext, boolean rejectExecution, Expression correlation, Expression maxRequestsExpression) {
        this.asyncExecutor = asyncExecutor;
        this.shutdownAsyncExecutor = shutdownAsyncExecutor;
        this.camelContext = camelContext;
        this.rejectExecution = rejectExecution;
        this.correlationExpression = correlation;
        this.maxRequestsExpression = (Expression)ObjectHelper.notNull((Object)maxRequestsExpression, (String)"maxConcurrentRequestsExpression");
    }

    protected static boolean handleInterrupt(Exchange exchange, AsyncCallback callback, InterruptedException e, boolean doneSync) {
        boolean forceShutdown = exchange.getContext().getShutdownStrategy().isForceShutdown();
        if (forceShutdown) {
            String msg = "Run not allowed as ShutdownStrategy is forcing shutting down, will reject executing exchange: " + String.valueOf(exchange);
            LOG.debug(msg);
            exchange.setException((Throwable)new RejectedExecutionException(msg, e));
        } else {
            exchange.setException((Throwable)e);
        }
        callback.done(doneSync);
        return doneSync;
    }

    protected static boolean handleException(Exchange exchange, AsyncCallback callback, Exception t, boolean doneSync) {
        exchange.setException((Throwable)t);
        callback.done(doneSync);
        return doneSync;
    }

    @Override
    public boolean isRejectExecution() {
        return this.rejectExecution;
    }

    public void setRejectExecution(boolean rejectExecution) {
        this.rejectExecution = rejectExecution;
    }

    @Override
    public boolean isAsyncDelayed() {
        return this.asyncDelayed;
    }

    public void setAsyncDelayed(boolean asyncDelayed) {
        this.asyncDelayed = asyncDelayed;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getRouteId() {
        return this.routeId;
    }

    public void setRouteId(String routeId) {
        this.routeId = routeId;
    }

    @Override
    public boolean isCallerRunsWhenRejected() {
        return this.callerRunsWhenRejected;
    }

    public void setCallerRunsWhenRejected(boolean callerRunsWhenRejected) {
        this.callerRunsWhenRejected = callerRunsWhenRejected;
    }

    @Override
    public void setMaximumRequestsExpression(Expression maxConcurrentRequestsExpression) {
        this.maxRequestsExpression = maxConcurrentRequestsExpression;
    }

    public Expression getMaximumRequestsExpression() {
        return this.maxRequestsExpression;
    }

    @Override
    public abstract String getMode();

    protected static enum State {
        SYNC,
        ASYNC,
        ASYNC_REJECTED;

    }
}

