/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.server.core.restrictor.policy;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.jolokia.server.core.restrictor.policy.AbstractChecker;
import org.jolokia.server.core.util.IpChecker;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NetworkChecker
extends AbstractChecker<String[]> {
    private final Set<String> allowedHostsSet;
    private final Set<Inet6Address> allowedIP6HostsSet;
    private Set<String> allowedSubnetsSet;
    private static final Pattern IP_PATTERN = Pattern.compile("^[\\d.]+$");
    private static final Pattern IP6_PATTERN = Pattern.compile("^[\\da-fA-F:]+$");
    private static final Pattern SUBNET_IP4_PATTERN = Pattern.compile("^[\\d.]+/[\\d.]+$");
    private static final Pattern SUBNET_IP6_PATTERN = Pattern.compile("^[\\da-fA-F:]+/[\\d.]+$");

    public NetworkChecker(Document pDoc) {
        NodeList nodes = pDoc.getElementsByTagName("remote");
        if (nodes.getLength() == 0) {
            this.allowedHostsSet = null;
            this.allowedIP6HostsSet = null;
            return;
        }
        this.allowedHostsSet = new HashSet<String>();
        this.allowedIP6HostsSet = new HashSet<Inet6Address>();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            NodeList childs = node.getChildNodes();
            for (int j = 0; j < childs.getLength(); ++j) {
                Node hostNode = childs.item(j);
                if (hostNode.getNodeType() != 1) continue;
                this.assertNodeName(hostNode, "host");
                String host = hostNode.getTextContent().trim().toLowerCase();
                if (host.startsWith("[") && host.endsWith("]")) {
                    host = host.substring(1, host.length() - 1);
                }
                if (SUBNET_IP4_PATTERN.matcher(host).matches() || SUBNET_IP6_PATTERN.matcher(host).matches()) {
                    if (this.allowedSubnetsSet == null) {
                        this.allowedSubnetsSet = new HashSet<String>();
                    }
                    this.allowedSubnetsSet.add(host);
                    continue;
                }
                if (host.contains(":")) {
                    try {
                        this.allowedIP6HostsSet.add((Inet6Address)Inet6Address.getByName(host));
                        continue;
                    }
                    catch (UnknownHostException e) {
                        throw new IllegalArgumentException("Invalid IPv6 address \"" + host + "\"", e);
                    }
                }
                this.allowedHostsSet.add(host);
            }
        }
    }

    @Override
    public boolean check(String[] pHostOrAddresses) {
        if (this.allowedHostsSet == null) {
            return true;
        }
        for (String addr : pHostOrAddresses) {
            if (this.allowedHostsSet.contains(addr)) {
                return true;
            }
            try {
                InetAddress ip6 = Inet6Address.getByName(addr);
                if (ip6 instanceof Inet6Address && this.allowedIP6HostsSet.contains(ip6)) {
                    return true;
                }
            }
            catch (UnknownHostException e) {
                return false;
            }
            if (this.allowedSubnetsSet == null || !IP_PATTERN.matcher(addr).matches() && !IP6_PATTERN.matcher(addr).matches()) continue;
            for (String subnet : this.allowedSubnetsSet) {
                if (!IpChecker.matches(subnet, addr)) continue;
                return true;
            }
        }
        return false;
    }
}

